/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.invariant.longs;

import java.util.Objects;
import net.openhft.chronicle.core.util.LongBiPredicate;

public enum LongBiCondition implements LongBiPredicate
{
    EQUAL_TO("==", (value, other) -> value == other),
    NOT_EQUAL_TO("!=", (value, other) -> value != other),
    GREATER_THAN(">", (value, other) -> value > other),
    GREATER_OR_EQUAL(">=", (value, other) -> value >= other),
    LESS_THAN("<", (value, other) -> value < other),
    LESS_OR_EQUAL("<=", (value, other) -> value <= other),
    BETWEEN_ZERO_AND("\u2208 [0, toExclusive), toExclusive =", (value, other) -> value >= 0L && value < other),
    BETWEEN_ZERO_AND_CLOSED("\u2208 [0, toInclusive], where toInclusive =", (value, other) -> value >= 0L && value < other),
    POWER_OF_TWO(" = 2^", (value, other) -> other < 31L && value == 1L << (int)other),
    LOG2(" = log2(other), other = ", (value, other) -> value < 31L && other == 1L << (int)value);

    private final String operation;
    private final LongBiPredicate predicate;

    private LongBiCondition(String operation, LongBiPredicate predicate) {
        this.operation = Objects.requireNonNull(operation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public boolean test(long value, long other) {
        return this.predicate.test(value, other);
    }

    @Override
    public LongBiPredicate negate() {
        switch (this) {
            case EQUAL_TO: {
                return NOT_EQUAL_TO;
            }
            case NOT_EQUAL_TO: {
                return EQUAL_TO;
            }
            case GREATER_THAN: {
                return LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return LESS_THAN;
            }
            case LESS_THAN: {
                return GREATER_OR_EQUAL;
            }
            case LESS_OR_EQUAL: {
                return GREATER_THAN;
            }
        }
        return LongBiPredicate.super.negate();
    }

    public String toString() {
        return this.operation;
    }
}

