/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.BufferUnderflowException;
import java.util.function.ToLongFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.OptimisedBytesStoreHash;
import net.openhft.chronicle.bytes.algo.VanillaBytesStoreHash;
import net.openhft.chronicle.core.annotation.NonNegative;
import org.jetbrains.annotations.NotNull;

public interface BytesStoreHash<B extends BytesStore>
extends ToLongFunction<B> {
    public static long hash(@NotNull BytesStore b) {
        return b.isDirectMemory() ? OptimisedBytesStoreHash.INSTANCE.applyAsLong(b) : VanillaBytesStoreHash.INSTANCE.applyAsLong(b);
    }

    public static long hash(@NotNull BytesStore b, @NonNegative long length) throws IllegalStateException, BufferUnderflowException {
        return b.isDirectMemory() ? OptimisedBytesStoreHash.INSTANCE.applyAsLong(b, length) : VanillaBytesStoreHash.INSTANCE.applyAsLong(b, length);
    }

    public static int hash32(BytesStore b) {
        long hash = BytesStoreHash.hash(b);
        return (int)(hash ^ hash >>> 32);
    }

    public static int hash32(@NotNull BytesStore b, @NonNegative int length) throws IllegalStateException, BufferUnderflowException {
        long hash = BytesStoreHash.hash(b, length);
        return (int)(hash ^ hash >>> 32);
    }

    public long applyAsLong(BytesStore var1, long var2) throws IllegalStateException, BufferUnderflowException;
}

