/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class JUnitUtil {
    private JUnitUtil() {
    }

    static boolean isJUnitAvailable() {
        return Stream.of("org.junit.jupiter.api.Test", "org.junit.Test").anyMatch(JUnitUtil::isClassAvailable);
    }

    static boolean isClassAvailable(@NotNull String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
        return true;
    }
}

