/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.analytics.internal;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.analytics.Analytics;
import net.openhft.chronicle.analytics.internal.AbstractGoogleAnalytics;
import net.openhft.chronicle.analytics.internal.AnalyticsConfiguration;
import net.openhft.chronicle.analytics.internal.HttpUtil;
import net.openhft.chronicle.analytics.internal.JsonUtil;
import org.jetbrains.annotations.NotNull;

final class GoogleAnalytics4
extends AbstractGoogleAnalytics
implements Analytics {
    GoogleAnalytics4(@NotNull AnalyticsConfiguration configuration) {
        super(configuration);
    }

    @Override
    void httpSend(@NotNull String eventName, @NotNull Map<String, String> eventParameters) {
        String url = this.configuration().url() + "?measurement_id=" + this.urlEncode(this.configuration().measurementId()) + "&api_secret=" + this.urlEncode(this.configuration().apiSecret());
        String json = GoogleAnalytics4.jsonFor(eventName, this.clientId(), eventParameters, this.configuration().userProperties());
        HttpUtil.send(url, json, this.configuration().errorLogger(), this.configuration().debugLogger());
    }

    static String jsonFor(@NotNull String eventName, @NotNull String clientId, @NotNull Map<String, String> eventParameters, @NotNull Map<String, String> userProperties) {
        return Stream.of("{", JsonUtil.jsonElement(" ", "clientId", clientId) + ',', JsonUtil.jsonElement(" ", "userId", clientId) + ',', JsonUtil.jsonElement(" ", "nonPersonalizedAds", true) + ',', ' ' + JsonUtil.asElement("events") + ": [{", JsonUtil.jsonElement("  ", "name", eventName) + ',', "  " + JsonUtil.asElement("params") + ": {", GoogleAnalytics4.renderMap(eventParameters, e -> JsonUtil.jsonElement("   ", (String)e.getKey(), e.getValue())), "  }", " }],", ' ' + JsonUtil.asElement("userProperties") + ": {", GoogleAnalytics4.renderMap(userProperties, GoogleAnalytics4::userProperty), " }", "}").collect(Collectors.joining(JsonUtil.nl()));
    }

    static String userProperty(Map.Entry<String, String> userProperty) {
        return String.format("  %s: {%n %s%n  }", JsonUtil.asElement(userProperty.getKey()), JsonUtil.jsonElement("   ", "value", userProperty.getValue()));
    }

    static String renderMap(@NotNull Map<String, String> map, @NotNull Function<Map.Entry<String, String>, String> mapper) {
        return map.entrySet().stream().map(mapper).collect(Collectors.joining(String.format(",%n", new Object[0])));
    }
}

