/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.CpuLayout;
import net.openhft.affinity.LockCheck;
import net.openhft.affinity.LockInventory;
import net.openhft.affinity.impl.NoCpuLayout;
import net.openhft.affinity.impl.VanillaCpuLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffinityLock
implements Closeable {
    public static final String AFFINITY_RESERVED = "affinity.reserved";
    public static final int PROCESSORS;
    public static final BitSet BASE_AFFINITY;
    public static final BitSet RESERVED_AFFINITY;
    static final int ANY_CPU = -1;
    private static final Logger LOGGER;
    private static final LockInventory LOCK_INVENTORY;
    private final int cpuId;
    private final boolean base;
    private final boolean reservable;
    private final LockInventory lockInventory;
    boolean bound = false;
    @Nullable
    Thread assignedThread;
    Throwable boundHere;

    AffinityLock(int cpuId, boolean base, boolean reservable, LockInventory lockInventory) {
        this.lockInventory = lockInventory;
        this.cpuId = cpuId;
        this.base = base;
        this.reservable = reservable;
    }

    public static void cpuLayout(@NotNull CpuLayout cpuLayout) {
        LOCK_INVENTORY.set(cpuLayout);
    }

    @NotNull
    public static CpuLayout cpuLayout() {
        return LOCK_INVENTORY.getCpuLayout();
    }

    private static BitSet getReservedAffinity0() {
        String reservedAffinity = System.getProperty(AFFINITY_RESERVED);
        if (BASE_AFFINITY != null && (reservedAffinity == null || reservedAffinity.trim().isEmpty())) {
            BitSet reserverable = new BitSet(PROCESSORS);
            reserverable.set(1, PROCESSORS, true);
            reserverable.andNot(BASE_AFFINITY);
            if (reserverable.isEmpty() && PROCESSORS > 1) {
                LoggerFactory.getLogger(AffinityLock.class).info("No isolated CPUs found, so assuming CPUs 1 to {} available.", (Object)(PROCESSORS - 1));
                reserverable = new BitSet(PROCESSORS);
                reserverable.set(1, PROCESSORS, true);
                reserverable.set(0, false);
                return reserverable;
            }
            return reserverable;
        }
        long[] longs = new long[]{Long.parseLong(reservedAffinity, 16)};
        return BitSet.valueOf(longs);
    }

    public static AffinityLock acquireLock() {
        return AffinityLock.acquireLock(true);
    }

    public static AffinityLock acquireCore() {
        return AffinityLock.acquireCore(true);
    }

    public static AffinityLock acquireLock(boolean bind) {
        return AffinityLock.acquireLock(bind, -1, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireLock(int cpuId) {
        return AffinityLock.acquireLock(true, cpuId, AffinityStrategies.ANY);
    }

    public static AffinityLock acquireCore(boolean bind) {
        return AffinityLock.acquireCore(bind, -1, AffinityStrategies.ANY);
    }

    private static AffinityLock acquireLock(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        return LOCK_INVENTORY.acquireLock(bind, cpuId, strategies);
    }

    private static AffinityLock acquireCore(boolean bind, int cpuId, AffinityStrategy ... strategies) {
        return LOCK_INVENTORY.acquireCore(bind, cpuId, strategies);
    }

    @NotNull
    public static String dumpLocks() {
        return LOCK_INVENTORY.dumpLocks();
    }

    private static boolean areAssertionsEnabled() {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return debug;
    }

    final void assignCurrentThread(boolean bind, boolean wholeCore) {
        this.assignedThread = Thread.currentThread();
        if (bind) {
            this.bind(wholeCore);
        }
    }

    public void bind() {
        this.bind(false);
    }

    public void bind(boolean wholeCore) {
        if (this.bound && this.assignedThread != null && this.assignedThread.isAlive()) {
            throw new IllegalStateException("cpu " + this.cpuId + " already bound to " + this.assignedThread);
        }
        if (AffinityLock.areAssertionsEnabled()) {
            this.boundHere = new Throwable("Bound here");
        }
        if (wholeCore) {
            this.lockInventory.bindWholeCore(this.cpuId);
        } else if (this.cpuId >= 0) {
            this.bound = true;
            this.assignedThread = Thread.currentThread();
            LOGGER.info("Assigning cpu {} to {}", (Object)this.cpuId, (Object)this.assignedThread);
        }
        if (this.cpuId >= 0) {
            BitSet affinity = new BitSet();
            affinity.set(this.cpuId, true);
            Affinity.setAffinity(affinity);
        }
    }

    final boolean canReserve() {
        if (!LockCheck.isCpuFree(this.cpuId)) {
            return false;
        }
        if (!this.reservable) {
            return false;
        }
        if (this.assignedThread != null) {
            if (this.assignedThread.isAlive()) {
                return false;
            }
            LOGGER.warn("Lock assigned to {} but this thread is dead.", (Object)this.assignedThread);
        }
        return true;
    }

    public AffinityLock acquireLock(AffinityStrategy ... strategies) {
        return AffinityLock.acquireLock(false, this.cpuId, strategies);
    }

    public void release() {
        this.lockInventory.release();
    }

    @Override
    public void close() {
        this.release();
    }

    protected void finalize() throws Throwable {
        if (this.bound) {
            LOGGER.warn("Affinity lock for " + this.assignedThread + " was discarded rather than release()d in a controlled manner.", this.boundHere);
            this.release();
        }
        super.finalize();
    }

    public int cpuId() {
        return this.cpuId;
    }

    public boolean isAllocated() {
        return this.cpuId >= 0;
    }

    public boolean isBound() {
        return this.bound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.assignedThread != null) {
            sb.append(this.assignedThread).append(" alive=").append(this.assignedThread.isAlive());
        } else if (this.reservable) {
            sb.append("Reserved for this application");
        } else if (this.base) {
            sb.append("General use CPU");
        } else {
            sb.append("CPU not available");
        }
        return sb.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(AffinityLock.class);
        int processors = Runtime.getRuntime().availableProcessors();
        VanillaCpuLayout cpuLayout = null;
        try {
            if (new File("/proc/cpuinfo").exists()) {
                cpuLayout = VanillaCpuLayout.fromCpuInfo();
                processors = cpuLayout.cpus();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load /proc/cpuinfo", (Throwable)e);
        }
        PROCESSORS = processors;
        BASE_AFFINITY = Affinity.getAffinity();
        RESERVED_AFFINITY = AffinityLock.getReservedAffinity0();
        LOCK_INVENTORY = new LockInventory(cpuLayout == null ? new NoCpuLayout(PROCESSORS) : cpuLayout);
    }
}

