/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.util.Util;

public class StepsOverviewPage
extends AbstractPage {
    public static final String WEB_PAGE = "overview-steps.html";

    public StepsOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "overviewSteps.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return WEB_PAGE;
    }

    @Override
    public void prepareReport() {
        this.context.put("all_steps", this.reportResult.getAllSteps());
        int allOccurrences = 0;
        long allDurations = 0L;
        for (StepObject stepObject : this.reportResult.getAllSteps()) {
            allOccurrences += stepObject.getTotalOccurrences();
            allDurations += stepObject.getDuration();
        }
        this.context.put("all_occurrences", (Object)allOccurrences);
        this.context.put("all_durations", (Object)Util.formatDuration(allDurations));
        long average = allDurations / (long)(allOccurrences == 0 ? 1 : allOccurrences);
        this.context.put("all_average", (Object)Util.formatDuration(average));
    }
}

