/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.woff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.mabb.fontverter.woff.Woff2Font;
import org.mabb.fontverter.woff.WoffConstants;
import org.mabb.fontverter.woff.WoffFont;
import org.mabb.fontverter.woff.WoffParser;
import org.mabb.fontverter.woff.WoffTable;
import org.meteogroup.jbrotli.BrotliDeCompressor;
import org.meteogroup.jbrotli.libloader.BrotliLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Woff2Parser
extends WoffParser {
    private static final Logger log = LoggerFactory.getLogger(Woff2Parser.class);

    @Override
    protected void initalizeFont() {
        if (this.font == null) {
            this.font = WoffFont.createBlankFont(2);
        }
    }

    @Override
    protected void parseTables() throws IOException {
        for (int i = 0; i < this.font.header.numTables; ++i) {
            this.parseDirectoryEntry();
        }
        this.parseCompressedBlockTableData();
    }

    private void parseDirectoryEntry() throws IOException {
        Woff2Font.Woff2Table table = (Woff2Font.Woff2Table)this.font.createTable();
        int[] rawFlag = this.input.readSplitBits(2);
        table.setTransform(rawFlag[0]);
        WoffConstants.TableFlagType flag = WoffConstants.TableFlagType.fromInt(rawFlag[1]);
        table.tag = flag.toString();
        if (flag.getValue() == 63) {
            String tagStr = new String(ByteBuffer.allocate(4).putInt(this.input.readInt()).array());
            log.error("!! arbitrary flag type not tested" + tagStr);
        }
        table.originalLength = this.input.readUIntBase128();
        if (table.isTableTransformed()) {
            table.transformLength = this.input.readUIntBase128();
        }
        if (table.transformLength == 0) {
            table.transformLength = table.originalLength;
        }
        log.debug("Woff2 parse table dir read: {} {} o-len:" + table.originalLength + " t-len:" + table.transformLength, (Object)table.tag, (Object)table.getTransform());
        this.font.getTables().add(table);
    }

    private void parseCompressedBlockTableData() throws IOException {
        byte[] block = this.input.readBytes(this.font.header.totalCompressedSize);
        block = this.brotliDecompress(block);
        int offset = 0;
        for (WoffTable tableOn : this.font.getTables()) {
            try {
                int end = tableOn.transformLength + offset;
                if (end > block.length) {
                    end = block.length;
                }
                tableOn.tableData = Arrays.copyOfRange(block, offset, end);
                offset += tableOn.transformLength;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private byte[] brotliDecompress(byte[] compressed) {
        BrotliLibraryLoader.loadBrotli();
        byte[] decompressed = new byte[compressed.length * 4];
        int decompressLength = new BrotliDeCompressor().deCompress(compressed, decompressed);
        return Arrays.copyOfRange(decompressed, 0, decompressLength);
    }
}

