/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;

public class SfntHeader {
    public static final int SFNT_HEADER_SIZE = 12;
    public static final String CFF_FLAVOR = "OTTO";
    public static final String VERSION_1 = "\u0000\u0001\u0000\u0000";
    public static final String VERSION_2 = "\u0000\u0002\u0000\u0000";
    public static final String VERSION_2_5 = "\u0000\u0002\u0005\u0000";
    @DataTypeProperty(dataType=DataTypeProperty.DataType.STRING, constLength=4)
    public String sfntFlavor = "";
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int numTables;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int searchRange;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int entrySelector;
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    public int rangeShift;

    public void setNumTables(int numTables) {
        this.numTables = numTables;
        this.searchRange = this.closestMaxPowerOfTwo(numTables) * 16;
        this.rangeShift = numTables * 16 - this.searchRange;
        this.entrySelector = (int)this.log2(this.closestMaxPowerOfTwo(numTables));
    }

    private int closestMaxPowerOfTwo(double number) {
        int powerOfTwo = 1;
        while ((double)(powerOfTwo * 2) < number) {
            powerOfTwo *= 2;
        }
        return powerOfTwo;
    }

    private double log2(int number) {
        return Math.log(number) / Math.log(2.0);
    }

    byte[] getData() throws IOException {
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(this);
    }

    float openTypeVersion() {
        if (this.sfntFlavor.equals(CFF_FLAVOR)) {
            return 3.0f;
        }
        if (this.sfntFlavor.equals(VERSION_2)) {
            return 2.0f;
        }
        if (this.sfntFlavor.equals(VERSION_2_5)) {
            return 2.5f;
        }
        return 1.0f;
    }

    static String toVersionString(float i) {
        return (double)i == 2.5 ? VERSION_2_5 : (i == 2.0f ? VERSION_2 : VERSION_1);
    }
}

