/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.DataTypeBindingDeserializer;
import org.mabb.fontverter.io.DataTypeBindingSerializer;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.UnknownTableType;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenTypeTable {
    public static final int TABLE_RECORD_SIZE = 16;
    private static List<Class> tableTypes;
    private static final Object factoryLock;
    private static Logger log;
    public OtfTableRecord record;
    public boolean isFromParsedFont = false;
    protected OpenTypeFont font;
    protected byte[] cachedUnpaddedData;
    private long checksum;
    private long offset;
    private int paddingAdded;
    private byte[] rawParsedData;

    public static OpenTypeTable createFromRecord(OtfTableRecord record, OpenTypeFont font) throws IllegalAccessException, InstantiationException, IOException {
        OpenTypeTable.initFactoryTableTypes();
        OpenTypeTable createdTable = null;
        for (Class typeOn : tableTypes) {
            OpenTypeTable tableOn = (OpenTypeTable)typeOn.newInstance();
            if (!tableOn.getTableType().equals(record.recordName)) continue;
            createdTable = tableOn;
            break;
        }
        if (createdTable == null) {
            createdTable = OpenTypeTable.createUnknownTableTypeFallback(record);
        }
        createdTable.record = record;
        createdTable.font = font;
        createdTable.offset = record.offset;
        return createdTable;
    }

    private static OpenTypeTable createUnknownTableTypeFallback(OtfTableRecord record) {
        log.debug(String.format("OTF table type '%s' not implemented, using fallback blind table parsing.", record.recordName));
        UnknownTableType table = new UnknownTableType(record.recordName);
        table.record = record;
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initFactoryTableTypes() {
        Object object = factoryLock;
        synchronized (object) {
            if (tableTypes == null) {
                Reflections reflections = new Reflections("org.mabb.fontverter", new Scanner[0]);
                Set adapterClasses = reflections.getSubTypesOf(OpenTypeTable.class);
                tableTypes = Arrays.asList(adapterClasses.toArray(new Class[adapterClasses.size()]));
                ArrayList<Class> filteredTables = new ArrayList<Class>();
                for (Class tableTypeOn : tableTypes) {
                    if (tableTypeOn.getCanonicalName().contains("Canned") || tableTypeOn == UnknownTableType.class) continue;
                    filteredTables.add(tableTypeOn);
                }
                tableTypes = filteredTables;
            }
        }
    }

    public abstract String getTableType();

    public final byte[] getData() throws IOException {
        return this.padTableData(this.getUnpaddedData());
    }

    public final byte[] getUnpaddedData() throws IOException {
        if (this.rawParsedData != null) {
            return this.rawParsedData;
        }
        if (this.cachedUnpaddedData != null) {
            return this.cachedUnpaddedData;
        }
        this.cachedUnpaddedData = this.generateUnpaddedData();
        return this.cachedUnpaddedData;
    }

    protected byte[] generateUnpaddedData() throws IOException {
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(this);
    }

    public void readData(byte[] data) throws IOException {
        if (!this.isParsingImplemented()) {
            this.rawParsedData = data;
            return;
        }
        DataTypeBindingDeserializer deserializer = new DataTypeBindingDeserializer();
        deserializer.deserialize(data, (Object)this);
    }

    protected boolean isParsingImplemented() {
        return true;
    }

    public byte[] getRecordData() throws IOException {
        byte[] data = this.getData();
        OtfTableRecord record = new OtfTableRecord();
        record.recordName = this.getTableType();
        record.length = data.length - this.paddingAdded;
        record.checksum = (int)this.checksum;
        record.offset = this.getOffset();
        DataTypeBindingSerializer serializer = new DataTypeBindingSerializer();
        return serializer.serialize(record);
    }

    private byte[] padTableData(byte[] tableData) {
        byte[] padding = FontVerterUtils.tablePaddingNeeded(tableData);
        this.paddingAdded = padding.length;
        return ArrayUtils.addAll((byte[])tableData, (byte[])padding);
    }

    public void finalizeRecord() throws IOException {
        this.checksum = FontVerterUtils.getTableChecksum(this.getData());
    }

    void normalize() throws IOException {
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    void resetCalculations() {
        this.checksum = 0L;
        this.offset = 0L;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void clearDataCache() {
        this.cachedUnpaddedData = null;
    }

    static {
        factoryLock = new Object();
        log = LoggerFactory.getLogger(OpenTypeTable.class);
    }

    public static class OtfTableRecord {
        @DataTypeProperty(dataType=DataTypeProperty.DataType.STRING, constLength=4)
        public String recordName;
        @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
        public long checksum;
        @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
        public long offset;
        @DataTypeProperty(dataType=DataTypeProperty.DataType.UINT)
        public long length;
        public byte[] originalData;
    }
}

