/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.TtfGlyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphTable
extends OpenTypeTable {
    private static final Logger log = LoggerFactory.getLogger(GlyphTable.class);
    List<TtfGlyph> glyphs = new LinkedList<TtfGlyph>();

    @Override
    public String getTableType() {
        return "glyf";
    }

    @Override
    protected byte[] generateUnpaddedData() throws IOException {
        FontDataOutputStream out = new FontDataOutputStream();
        for (TtfGlyph glyphOn : this.glyphs) {
            if (glyphOn.isEmpty()) continue;
            out.write(glyphOn.generateData());
        }
        return out.toByteArray();
    }

    @Override
    public void readData(byte[] data) throws IOException {
        super.readData(data);
        FontDataInputStream reader = new FontDataInputStream(data);
        Long[] offsets = this.font.getLocaTable().getOffsets();
        for (int i = 0; i < offsets.length - 1; ++i) {
            Long offset = offsets[i];
            long length = offsets[i + 1] - offset;
            if (length == 0L) {
                this.glyphs.add(new TtfGlyph());
                continue;
            }
            if (offset >= (long)data.length) {
                log.error("Invalid loca table offset, offset greater than glyf table length");
                continue;
            }
            try {
                reader.seek(offset.intValue());
                byte[] glyphData = reader.readBytes((int)length);
                TtfGlyph glyph = TtfGlyph.parse(glyphData, this.font);
                this.glyphs.add(glyph);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public List<TtfGlyph> getGlyphs() {
        return this.glyphs;
    }

    public List<TtfGlyph> getNonEmptyGlyphs() {
        LinkedList<TtfGlyph> nonEmpty = new LinkedList<TtfGlyph>();
        for (TtfGlyph glyphOn : this.glyphs) {
            if (glyphOn.isEmpty()) continue;
            nonEmpty.add(glyphOn);
        }
        return nonEmpty;
    }
}

