/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.io.FontDataOutputStream;
import org.mabb.fontverter.opentype.CmapSubTable;
import org.mabb.fontverter.opentype.Format4SubTable;
import org.mabb.fontverter.opentype.GlyphMapReader;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.opentype.OtfNameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmapTable
extends OpenTypeTable {
    private static Logger log = LoggerFactory.getLogger(CmapTable.class);
    private static final int CMAP_HEADER_SIZE = 4;
    private Format4SubTable windowsTable;
    private Format4SubTable unixTable;
    private CmapSubTable.Format0SubTable macTable;
    private List<CmapSubTable> subTables = new ArrayList<CmapSubTable>();
    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int version;

    @DataTypeProperty(dataType=DataTypeProperty.DataType.USHORT)
    int numTables() {
        return this.subTables.size();
    }

    @Override
    public String getTableType() {
        return "cmap";
    }

    @Override
    protected byte[] generateUnpaddedData() throws IOException {
        this.calculateOffsets();
        FontDataOutputStream writer = new FontDataOutputStream(FontDataOutputStream.OPEN_TYPE_CHARSET);
        writer.write(super.generateUnpaddedData());
        for (CmapSubTable tableOn : this.subTables) {
            writer.write(tableOn.getRecordData());
        }
        for (CmapSubTable tableOn : this.subTables) {
            writer.write(tableOn.getData());
        }
        return writer.toByteArray();
    }

    @Override
    public void readData(byte[] data) throws IOException {
        FontDataInputStream input = new FontDataInputStream(data);
        this.version = input.readUnsignedShort();
        int numTables = input.readUnsignedShort();
        ArrayList<SubTableHeader> headers = new ArrayList<SubTableHeader>();
        for (int i = 0; i < numTables; ++i) {
            SubTableHeader header = new SubTableHeader();
            header.platformID = input.readUnsignedShort();
            header.encodingID = input.readUnsignedShort();
            header.offset = input.readUnsignedInt();
            headers.add(header);
        }
        for (SubTableHeader header : headers) {
            CmapSubTable subTable = null;
            input.seek((int)header.offset);
            int format = input.readUnsignedShort();
            if (format == 0) {
                subTable = new CmapSubTable.Format0SubTable();
            } else if (format == 2) {
                subTable = new CmapSubTable.Format2SubTable();
            } else if (format == 4) {
                subTable = new Format4SubTable();
            } else if (format == 6) {
                subTable = new CmapSubTable.Format6SubTable();
            } else if (format == 8) {
                subTable = new CmapSubTable.Format8SubTable();
            } else if (format == 10) {
                subTable = new CmapSubTable.Format10SubTable();
            } else if (format == 12) {
                subTable = new CmapSubTable.Format12SubTable();
            } else if (format == 13) {
                subTable = new CmapSubTable.Format13SubTable();
            } else if (format == 14) {
                subTable = new CmapSubTable.Format14SubTable();
            }
            if (subTable == null) continue;
            subTable.readData(input);
            subTable.setEncodingId(header.encodingID);
            subTable.setPlatformId(header.platformID);
            this.subTables.add(subTable);
        }
    }

    public static CmapTable createDefaultTable() {
        CmapTable table = new CmapTable();
        table.version = 0;
        table.unixTable = new Format4SubTable();
        table.unixTable.setPlatformId(0);
        table.unixTable.setEncodingId(3);
        table.subTables.add(table.unixTable);
        table.macTable = new CmapSubTable.Format0SubTable();
        table.macTable.setPlatformId(1);
        table.macTable.setEncodingId(0);
        table.subTables.add(table.macTable);
        table.windowsTable = new Format4SubTable();
        table.windowsTable.setPlatformId(3);
        table.windowsTable.setEncodingId(1);
        table.subTables.add(table.windowsTable);
        return table;
    }

    public void addGlyphMapping(Integer charCode, Integer glyphId) {
        this.windowsTable.addGlyphMapping(charCode, glyphId);
        this.unixTable.addGlyphMapping(charCode, glyphId);
    }

    public void addGlyphMapping(List<GlyphMapReader.GlyphMapping> mapping) {
        for (GlyphMapReader.GlyphMapping mappingOn : mapping) {
            this.addGlyphMapping(mappingOn.charCode, mappingOn.glyphId);
        }
    }

    public int getGlyphCount() {
        if (this.subTables.size() == 0) {
            return 0;
        }
        for (CmapSubTable subTableOn : this.subTables) {
            if (subTableOn.glyphCount() == 0) continue;
            return subTableOn.glyphCount();
        }
        return 0;
    }

    public OtfNameConstants.OtfEncodingType getCmapEncodingType() {
        for (CmapSubTable subTableOn : this.subTables) {
            if (subTableOn.getPlatformId() != 3) continue;
            return subTableOn.getEncodingType();
        }
        return OtfNameConstants.OtfEncodingType.Unicode_BMP;
    }

    public List<GlyphMapReader.GlyphMapping> getGlyphMappings() {
        if (this.subTables.size() == 0) {
            return new ArrayList<GlyphMapReader.GlyphMapping>();
        }
        for (CmapSubTable subTableOn : this.subTables) {
            if (subTableOn.glyphCount() == 0) continue;
            return subTableOn.getGlyphMappings();
        }
        return this.subTables.get(0).getGlyphMappings();
    }

    private void calculateOffsets() throws IOException {
        int offset = this.subTables.size() * 8 + 4;
        for (CmapSubTable tableOn : this.subTables) {
            tableOn.setSubTableOffset(offset);
            offset += tableOn.getData().length;
        }
    }

    static class SubTableHeader {
        int platformID;
        int encodingID;
        long offset;

        SubTableHeader() {
        }
    }
}

