/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gwt.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.ltgt.gwt.maven.CommandLine;
import net.ltgt.gwt.maven.GwtOptions;
import net.ltgt.gwt.maven.SourcesAsResourcesHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="compile", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CompileMojo
extends AbstractMojo
implements GwtOptions {
    @Parameter(property="gwt.draftCompile", defaultValue="false")
    private boolean draftCompile;
    @Parameter(defaultValue="${project.build.directory}/gwt/deploy", required=true)
    private File deploy;
    @Parameter
    private File extra;
    @Parameter(property="gwt.localWorkers")
    private String localWorkers;
    @Parameter(property="gwt.logLevel")
    private String logLevel;
    @Parameter(required=true)
    private String moduleName;
    @Parameter
    private String moduleShortName;
    @Parameter(property="gwt.optimize")
    private Integer optimize;
    @Parameter(property="maven.compiler.source")
    private String sourceLevel;
    @Parameter(property="gwt.style")
    private String style;
    @Parameter(property="gwt.failOnError")
    private Boolean failOnError;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File webappDirectory;
    @Parameter(defaultValue="${project.build.directory}/gwt/work", required=true)
    private File workDir;
    @Parameter
    private List<String> compilerArgs;
    @Parameter
    private List<String> jvmArgs;
    @Parameter
    private Map<String, String> systemProperties;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    private int staleMillis;
    @Parameter(property="gwt.forceCompilation", defaultValue="false")
    private boolean forceCompilation;
    @Parameter(property="gwt.skipCompilation", defaultValue="false")
    private boolean skipCompilation;
    @Parameter
    private String jvm;
    @Parameter
    private Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException {
        if (this.skipCompilation) {
            this.getLog().info((CharSequence)"GWT compilation is skipped");
            return;
        }
        List<String> sourceRoots = SourcesAsResourcesHelper.filterSourceRoots(this.getLog(), this.project.getResources(), this.project.getCompileSourceRoots());
        if (!this.forceCompilation && !this.isStale(sourceRoots)) {
            this.getLog().info((CharSequence)"Compilation output seems uptodate. GWT compilation skipped.");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.jvmArgs != null) {
            args.addAll(this.jvmArgs);
        }
        if (this.systemProperties != null) {
            for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        args.add("com.google.gwt.dev.Compiler");
        args.addAll(GwtOptions.CommandlineBuilder.buildArgs(this.getLog(), this));
        if (this.failOnError != null) {
            args.add(this.failOnError != false ? "-failOnError" : "-nofailOnError");
        }
        if (this.compilerArgs != null) {
            args.addAll(this.compilerArgs);
        }
        args.add(this.moduleName);
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        cp.addAll(sourceRoots);
        try {
            cp.addAll(this.project.getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        CommandLine commandLine = new CommandLine(this.getLog(), this.project, this.session, this.toolchainManager, this.jdkToolchain, this.jvm);
        commandLine.execute(cp, args);
        if (this.isStale(sourceRoots)) {
            String shortName = this.getModuleShortName();
            File nocacheJs = new File(this.webappDirectory, shortName + File.separator + shortName + ".nocache.js");
            nocacheJs.setLastModified(System.currentTimeMillis());
        }
    }

    private boolean isStale(List<String> sourceRoots) throws MojoExecutionException {
        if (!this.webappDirectory.exists()) {
            return true;
        }
        String shortName = this.getModuleShortName();
        final File nocacheJs = new File(this.webappDirectory, shortName + File.separator + shortName + ".nocache.js");
        if (!nocacheJs.isFile()) {
            this.getLog().debug((CharSequence)(nocacheJs.getPath() + " file found or is not a file: recompiling"));
            return true;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found *.nocache.js at " + nocacheJs.getAbsolutePath()));
        }
        StaleSourceScanner scanner = new StaleSourceScanner((long)this.staleMillis);
        scanner.addSourceMapping(new SourceMapping(){
            final Set<File> targetFiles;
            {
                this.targetFiles = Collections.singleton(nocacheJs);
            }

            public Set<File> getTargetFiles(File targetDir, String source) throws InclusionScanException {
                return this.targetFiles;
            }
        });
        for (String sourceRoot : sourceRoots) {
            if (!this.isStale(scanner, new File(sourceRoot), nocacheJs)) continue;
            return true;
        }
        if (this.isStale(scanner, new File(this.project.getBuild().getOutputDirectory()), nocacheJs)) {
            return true;
        }
        if (this.isStale(scanner, this.project.getFile(), nocacheJs)) {
            return true;
        }
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("compile");
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifactFilter.include(artifact) || !this.isStale(scanner, artifact.getFile(), nocacheJs)) continue;
            return true;
        }
        return false;
    }

    private boolean isStale(StaleSourceScanner scanner, File sourceFile, File targetFile) throws MojoExecutionException {
        if (!sourceFile.isDirectory()) {
            boolean stale;
            boolean bl = stale = targetFile.lastModified() + (long)this.staleMillis < sourceFile.lastModified();
            if (stale && this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Source file is newer than nocache.js, recompiling: " + sourceFile.getAbsolutePath()));
            }
            return stale;
        }
        try {
            boolean stale;
            Set sourceFiles = scanner.getIncludedSources(sourceFile, this.webappDirectory);
            boolean bl = stale = !sourceFiles.isEmpty();
            if (stale && this.getLog().isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (File source : sourceFiles) {
                    sb.append("\n - ").append(source.getAbsolutePath());
                }
                this.getLog().debug((CharSequence)("Source files are newer than nocache.js, recompiling: " + sb.toString()));
            }
            return stale;
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source root: '" + sourceFile.getPath() + "' for stale files to recompile.", (Exception)((Object)e));
        }
    }

    private String getModuleShortName() {
        if (StringUtils.isBlank((String)this.moduleShortName)) {
            return this.moduleName;
        }
        return this.moduleShortName;
    }

    @Override
    @Nullable
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    @Nullable
    public String getStyle() {
        return this.style;
    }

    @Override
    @Nullable
    public Integer getOptimize() {
        return this.optimize;
    }

    @Override
    public File getWarDir() {
        return this.webappDirectory;
    }

    @Override
    public File getWorkDir() {
        return this.workDir;
    }

    @Override
    public File getDeployDir() {
        return this.deploy;
    }

    @Override
    @Nullable
    public File getExtraDir() {
        return this.extra;
    }

    @Override
    public boolean isDraftCompile() {
        return this.draftCompile;
    }

    @Override
    @Nullable
    public String getLocalWorkers() {
        return this.localWorkers;
    }

    @Override
    @Nullable
    public String getSourceLevel() {
        return this.sourceLevel;
    }
}

