/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;

public class DeferredLogstashMarker
extends LogstashMarker {
    public static final String DEFERRED_MARKER_NAME = "DEFERRED";
    private final Supplier<? extends LogstashMarker> logstashMarkerSupplier;

    public DeferredLogstashMarker(Supplier<? extends LogstashMarker> logstashMarkerSupplier) {
        super(DEFERRED_MARKER_NAME);
        this.logstashMarkerSupplier = Objects.requireNonNull(logstashMarkerSupplier, "logstashMarkerSupplier must not be null");
    }

    @Override
    public void writeTo(JsonGenerator generator) throws IOException {
        this.writeMarker(generator, this.logstashMarkerSupplier.get());
    }

    private void writeMarker(JsonGenerator generator, Marker marker) throws IOException {
        if (marker == null) {
            return;
        }
        if (marker instanceof LogstashMarker) {
            ((LogstashMarker)marker).writeTo(generator);
        }
        if (marker.hasReferences()) {
            for (Marker next : marker) {
                this.writeMarker(generator, next);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

