/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.marker.LogstashMarker;
import org.slf4j.Marker;

public class LogstashMarkersJsonProvider
extends AbstractJsonProvider<ILoggingEvent> {
    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        this.writeLogstashMarkerIfNecessary(generator, event.getMarker());
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) throws IOException {
        if (marker != null) {
            if (LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator);
            }
            if (marker.hasReferences()) {
                for (Marker next : marker) {
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    public static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }
}

