/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.4.0")
public interface TryExecutionResult {
    public static TryExecutionResult satisfied() {
        return TryExecutionResult.satisfied(false);
    }

    public static TryExecutionResult satisfied(final boolean shouldPropertyFinishEarly) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.SATISFIED;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.empty();
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return shouldPropertyFinishEarly;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s)", this.status().name());
            }
        };
    }

    public static TryExecutionResult falsified(final @Nullable Throwable throwable) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.FALSIFIED;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return false;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s): %s", this.status().name(), this.throwable().map(Throwable::getMessage).orElse("null"));
            }
        };
    }

    public static TryExecutionResult invalid(final @Nullable Throwable throwable) {
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return Status.INVALID;
            }

            @Override
            public Optional<Throwable> throwable() {
                return Optional.ofNullable(throwable);
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return false;
            }

            public String toString() {
                return String.format("TryExecutionResult(%s)", this.status().name());
            }
        };
    }

    public static TryExecutionResult invalid() {
        return TryExecutionResult.invalid(null);
    }

    default public boolean isSatisfied() {
        return this.status() == Status.SATISFIED;
    }

    default public boolean isFalsified() {
        return this.status() == Status.FALSIFIED;
    }

    default public boolean isInvalid() {
        return this.status() == Status.INVALID;
    }

    @API(status=API.Status.MAINTAINED, since="1.5.5")
    default public List<String> footnotes() {
        return Collections.emptyList();
    }

    @API(status=API.Status.MAINTAINED, since="1.5.5")
    default public TryExecutionResult withFootnotes(Collection<String> otherFootnotes) {
        final TryExecutionResult self = this;
        final ArrayList<String> footnotes = new ArrayList<String>(this.footnotes());
        footnotes.addAll(otherFootnotes);
        return new TryExecutionResult(){

            @Override
            public Status status() {
                return self.status();
            }

            @Override
            public Optional<Throwable> throwable() {
                return self.throwable();
            }

            @Override
            public boolean shouldPropertyFinishEarly() {
                return self.shouldPropertyFinishEarly();
            }

            @Override
            public List<String> footnotes() {
                return footnotes;
            }
        };
    }

    public Status status();

    public Optional<Throwable> throwable();

    public boolean shouldPropertyFinishEarly();

    public static enum Status {
        SATISFIED,
        FALSIFIED,
        INVALID;

    }
}

