/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.validator;

import java.io.IOException;
import java.net.URI;
import net.javacrumbs.springws.test.RequestProcessor;
import net.javacrumbs.springws.test.WsTestException;
import net.javacrumbs.springws.test.common.DefaultMessageComparator;
import net.javacrumbs.springws.test.common.MessageComparator;
import net.javacrumbs.springws.test.lookup.ResourceLookup;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

public class XmlCompareRequestValidator
implements Ordered,
RequestProcessor {
    static final int DEFAULT_ORDER = 10;
    private int order = 10;
    private ResourceLookup controlResourceLookup;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();
    private boolean failIfControlResourceNotFound;
    private MessageComparator messageComparator = new DefaultMessageComparator();

    public WebServiceMessage processRequest(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessage request) throws IOException {
        this.validateRequest(uri, request);
        return null;
    }

    protected void validateRequest(URI uri, WebServiceMessage message) throws IOException {
        Resource controlResource = this.controlResourceLookup.lookupResource(uri, message);
        if (controlResource != null) {
            this.compareMessage(message, controlResource);
        } else {
            this.onControlResourceNotFound(uri, message);
        }
    }

    protected void compareMessage(WebServiceMessage message, Resource controlResource) throws IOException {
        this.messageComparator.compareMessage(message, controlResource);
    }

    protected void onControlResourceNotFound(URI uri, WebServiceMessage message) {
        if (this.failIfControlResourceNotFound) {
            throw new WsTestException("Control resource not found for " + uri + " and " + this.getXmlUtil().serializeDocument(message));
        }
        this.logger.warn((Object)"Can not find resource to validate with.");
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.controlResourceLookup, (String)"ControlResourceLookup has to be set");
    }

    public ResourceLookup getControlResourceLookup() {
        return this.controlResourceLookup;
    }

    public void setControlResourceLookup(ResourceLookup controlResourceLookup) {
        this.controlResourceLookup = controlResourceLookup;
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
        this.messageComparator.setXmlUtil(xmlUtil);
    }

    public boolean isFailIfControlResourceNotFound() {
        return this.failIfControlResourceNotFound;
    }

    public void setFailIfControlResourceNotFound(boolean failIfControlResourceNotFound) {
        this.failIfControlResourceNotFound = failIfControlResourceNotFound;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.messageComparator.setIgnoreWhitespace(ignoreWhitespace);
    }

    public boolean isIgnoreWhitespace() {
        return this.messageComparator.isIgnoreWhitespace();
    }

    public MessageComparator getMessageComparator() {
        return this.messageComparator;
    }

    public void setMessageComparator(DefaultMessageComparator messageComparator) {
        this.messageComparator = messageComparator;
    }
}

