/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.simple.annotation;

import net.javacrumbs.springws.test.context.WsTestContextHolder;
import net.javacrumbs.springws.test.simple.annotation.ThreadLocalWsMockControlFactoryBean;
import net.javacrumbs.springws.test.simple.annotation.WsMockControlMockWebServiceMessageSender;
import net.javacrumbs.springws.test.util.MockMessageSenderInjector;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WsMockControlTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String MESSAGE_SENDER_BEAN_NAME = "net.javacrumbs.springws.test.simple.annotation.WsMockControlMockWebServiceMessageSender";
    private static final String MOCK_CONTROL_BEAN_NAME = "net.javacrumbs.springws.test.simple.annotation.WsMockControl";

    public void prepareTestInstance(TestContext testContext) throws Exception {
        ConfigurableListableBeanFactory beanFactory = ((AbstractApplicationContext)testContext.getApplicationContext()).getBeanFactory();
        if (!beanFactory.containsBean(MOCK_CONTROL_BEAN_NAME)) {
            beanFactory.registerSingleton(MOCK_CONTROL_BEAN_NAME, this.createWsMockControlFactoryBean());
            beanFactory.registerSingleton(MESSAGE_SENDER_BEAN_NAME, (Object)this.createMessageSender());
            new MockMessageSenderInjector().postProcessBeanFactory(beanFactory);
        }
    }

    protected WebServiceMessageSender createMessageSender() {
        return new WsMockControlMockWebServiceMessageSender();
    }

    protected Object createWsMockControlFactoryBean() {
        return new ThreadLocalWsMockControlFactoryBean();
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        ThreadLocalWsMockControlFactoryBean.clean();
        WsTestContextHolder.getTestContext().clear();
    }
}

