/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.helper;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.WebServiceMessageReceiver;

class InMemoryWebServiceConnection
implements WebServiceConnection {
    private final URI uri;
    private final WebServiceMessageFactory messageFactory;
    private final WebServiceMessageReceiver webServiceMessageReceiver;
    private MessageContext context;

    public InMemoryWebServiceConnection(URI uri, WebServiceMessageFactory messageFactory, WebServiceMessageReceiver messageReceiver) {
        this.uri = uri;
        this.messageFactory = messageFactory;
        this.webServiceMessageReceiver = messageReceiver;
    }

    public void send(WebServiceMessage message) throws IOException {
        this.context = this.createMessageContext(message);
        try {
            this.getWebServiceMessageReceiver().receive(this.context);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        return this.context.getResponse();
    }

    protected DefaultMessageContext createMessageContext(WebServiceMessage message) {
        return new DefaultMessageContext(message, this.messageFactory);
    }

    public void close() throws IOException {
    }

    public String getErrorMessage() throws IOException {
        return null;
    }

    public URI getUri() throws URISyntaxException {
        return this.uri;
    }

    public boolean hasError() throws IOException {
        return false;
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public WebServiceMessageReceiver getWebServiceMessageReceiver() {
        return this.webServiceMessageReceiver;
    }

    public MessageContext getContext() {
        return this.context;
    }
}

