/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.expression;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import net.javacrumbs.springws.test.context.WsTestContextHolder;
import org.springframework.beans.BeanWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsTestXPathVariableResolver
implements XPathVariableResolver {
    private final URI uri;

    public WsTestXPathVariableResolver(URI uri) {
        this.uri = uri;
    }

    @Override
    public Object resolveVariable(QName variableName) {
        String property = variableName.getLocalPart();
        property = this.normalizeContextVariable(property);
        return new BeanWrapperImpl((Object)this).getPropertyValue(property);
    }

    String normalizeContextVariable(String property) {
        if (property.startsWith("context.")) {
            int endIndex = property.indexOf(46, 8);
            endIndex = endIndex != -1 ? endIndex : property.length();
            property = "context[" + property.substring(8, endIndex) + "]" + property.substring(endIndex);
        }
        return property;
    }

    public URI getUri() {
        return this.uri;
    }

    public Map<String, Object> getContext() {
        return WsTestContextHolder.getTestContext().getAttributeMap();
    }
}

