/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.common;

import java.io.IOException;
import java.util.Arrays;
import javax.xml.transform.Source;
import net.javacrumbs.springws.test.WsTestException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.xml.sax.SAXParseException;

public class SchemaValidator {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void validate(WebServiceMessage message, XmlValidator validator) throws IOException {
        Source requestSource = message.getPayloadSource();
        if (requestSource != null) {
            Object[] errors = validator.validate(requestSource);
            if (!ObjectUtils.isEmpty((Object[])errors)) {
                this.handleRequestValidationErrors(message, (SAXParseException[])errors);
            }
            this.logger.debug((Object)"Request message validated");
        } else {
            this.logger.warn((Object)"Request source is null");
        }
    }

    public XmlValidator createValidatorFromSchemas(Resource[] schemas, String schemaLanguage) throws IOException {
        Assert.hasLength((String)schemaLanguage, (String)"schemaLanguage is required");
        for (int i = 0; i < schemas.length; ++i) {
            Assert.isTrue((boolean)schemas[i].exists(), (String)("schema [" + schemas[i] + "] does not exist"));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Validating using \"" + StringUtils.arrayToCommaDelimitedString((Object[])schemas) + "\""));
        }
        return XmlValidatorFactory.createValidator((Resource[])schemas, (String)schemaLanguage);
    }

    protected void handleRequestValidationErrors(WebServiceMessage message, SAXParseException[] errors) {
        throw new WsTestException("Request not valid. " + Arrays.toString(errors), message);
    }
}

