/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test.common;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import net.javacrumbs.springws.test.util.TransportInputStreamWrapper;
import net.javacrumbs.springws.test.util.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;

public class MessageGenerator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlUtil xmlUtil = DefaultXmlUtil.getInstance();
    private boolean alwaysCreateEnvelope = false;
    private boolean neverCreateEnvelope = false;

    public WebServiceMessage generateMessage(WebServiceMessageFactory messageFactory, Resource resource) throws IOException {
        if (this.shouldCreateSoapEnvelope(resource)) {
            WebServiceMessage message = messageFactory.createWebServiceMessage();
            this.getXmlUtil().transform(new StreamSource(resource.getInputStream()), message.getPayloadResult());
            this.logMessage(message);
            return message;
        }
        WebServiceMessage message = messageFactory.createWebServiceMessage(this.createInputStream(resource));
        this.logMessage(message);
        return message;
    }

    protected boolean shouldCreateSoapEnvelope(Resource resultResource) throws IOException {
        return this.alwaysCreateEnvelope || !this.neverCreateEnvelope && !this.getXmlUtil().isSoap(this.xmlUtil.loadDocument(resultResource));
    }

    private void logMessage(WebServiceMessage message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Loaded message " + this.getXmlUtil().serializeDocument(message)));
        }
    }

    protected InputStream createInputStream(Resource resultResource) throws IOException {
        return new TransportInputStreamWrapper(resultResource);
    }

    public XmlUtil getXmlUtil() {
        return this.xmlUtil;
    }

    public void setXmlUtil(XmlUtil xmlUtil) {
        this.xmlUtil = xmlUtil;
    }

    public boolean isAlwaysCreateEnvelope() {
        return this.alwaysCreateEnvelope;
    }

    public void setAlwaysCreateEnvelope(boolean alwaysCreateEnvelope) {
        this.alwaysCreateEnvelope = alwaysCreateEnvelope;
    }

    public boolean isNeverCreateEnvelope() {
        return this.neverCreateEnvelope;
    }

    public void setNeverCreateEnvelope(boolean neverCreateEnvelope) {
        this.neverCreateEnvelope = neverCreateEnvelope;
    }
}

