/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.springws.test;

import javax.xml.transform.Source;
import net.javacrumbs.springws.test.util.DefaultXmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ws.WebServiceMessage;

public class WsTestException
extends RuntimeException {
    private static final long serialVersionUID = 8882366230559729512L;
    private static final Log logger = LogFactory.getLog(WsTestException.class);
    private static final String SEPARATOR = "----------------------\n";
    private Source sourceMessage;
    private Source controlMessage;

    public WsTestException() {
    }

    public WsTestException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public WsTestException(String errorMessage) {
        super(errorMessage);
    }

    public WsTestException(String errorMessage, Source sourceMessage, Source controlMessage) {
        super(errorMessage);
        this.sourceMessage = sourceMessage;
        this.controlMessage = controlMessage;
    }

    public WsTestException(String errorMessage, WebServiceMessage sourceMessage) {
        super(errorMessage);
        this.sourceMessage = DefaultXmlUtil.getInstance().getEnvelopeSource(sourceMessage);
    }

    public WsTestException(Throwable cause) {
        super(cause);
    }

    public Source getSourceMessage() {
        return this.sourceMessage;
    }

    public String getMessage() {
        String serializedSourceMessage = this.serializeSource("Source message:", this.sourceMessage);
        String serializedControlMessage = this.serializeSource("Control message:", this.controlMessage);
        return super.getMessage() + serializedSourceMessage + serializedControlMessage;
    }

    private String serializeSource(String label, Source source) {
        try {
            return source != null ? "\n----------------------\n" + label + "\n" + DefaultXmlUtil.getInstance().serializeDocument(source) : "";
        }
        catch (Exception e) {
            logger.warn((Object)("Can not serialize " + label), (Throwable)e);
            return "";
        }
    }
}

