/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.springws.client;

import java.util.ArrayList;
import java.util.Arrays;
import net.javacrumbs.smock.common.EndpointInterceptorClientAdapter;
import net.javacrumbs.smock.common.client.CommonSmockClient;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.test.client.MockWebServiceServer;
import org.springframework.ws.test.support.MockStrategiesHelper;

public abstract class SmockClient
extends CommonSmockClient {
    public static MockWebServiceServer createServer(WebServiceTemplate webServiceTemplate, EndpointInterceptor[] interceptors) {
        if (interceptors != null && interceptors.length > 0) {
            ArrayList<ClientInterceptor> newInterceptors = new ArrayList<ClientInterceptor>();
            if (webServiceTemplate.getInterceptors() != null) {
                newInterceptors.addAll(Arrays.asList(webServiceTemplate.getInterceptors()));
            }
            newInterceptors.addAll(Arrays.asList(EndpointInterceptorClientAdapter.wrapEndpointInterceptors((EndpointInterceptor[])interceptors)));
            webServiceTemplate.setInterceptors(newInterceptors.toArray(new ClientInterceptor[newInterceptors.size()]));
        }
        return MockWebServiceServer.createServer((WebServiceTemplate)webServiceTemplate);
    }

    public static MockWebServiceServer createServer(WebServiceGatewaySupport gatewaySupport, EndpointInterceptor[] interceptors) {
        Assert.notNull((Object)gatewaySupport, (String)"'gatewaySupport' must not be null");
        return SmockClient.createServer(gatewaySupport.getWebServiceTemplate(), interceptors);
    }

    public static MockWebServiceServer createServer(ApplicationContext applicationContext, EndpointInterceptor[] interceptors) {
        MockStrategiesHelper strategiesHelper = new MockStrategiesHelper(applicationContext);
        WebServiceTemplate webServiceTemplate = (WebServiceTemplate)strategiesHelper.getStrategy(WebServiceTemplate.class);
        if (webServiceTemplate != null) {
            return SmockClient.createServer(webServiceTemplate, interceptors);
        }
        WebServiceGatewaySupport gatewaySupport = (WebServiceGatewaySupport)strategiesHelper.getStrategy(WebServiceGatewaySupport.class);
        if (gatewaySupport != null) {
            return SmockClient.createServer(gatewaySupport, interceptors);
        }
        throw new IllegalArgumentException("Could not find either WebServiceTemplate or WebServiceGatewaySupport in application context");
    }
}

