/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common.server;

import javax.xml.transform.Source;
import net.javacrumbs.smock.common.MessageHelper;
import net.javacrumbs.smock.common.server.CommonSmockServer;
import net.javacrumbs.smock.common.server.MockWebServiceClientResponseActions;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.test.server.RequestCreator;
import org.springframework.ws.test.server.ResponseActions;
import org.springframework.ws.test.support.AssertionErrors;

public class ServerTestHelper
extends CommonSmockServer {
    private static WebServiceMessageFactory messageFactory = ServerTestHelper.createMessageFactory();
    private static MessageHelper messageHelper = new MessageHelper(messageFactory);

    public static <T> T createRequest(String messageLocation, Class<T> targetClass) {
        return ServerTestHelper.createRequest(ServerTestHelper.fromResource(messageLocation), targetClass);
    }

    public static <T> T createRequest(Source messageSource, Class<T> targetClass) {
        return ServerTestHelper.createRequest(ServerTestHelper.withMessage(messageSource), targetClass);
    }

    public static <T> T createRequest(RequestCreator requestCreator, Class<T> targetClass) {
        try {
            return messageHelper.deserialize(requestCreator.createRequest(messageFactory), targetClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not deserialize message.", e);
        }
    }

    public static WebServiceMessage serialize(Object object) {
        try {
            WebServiceMessage message = messageHelper.serialize(object);
            if (message == null) {
                AssertionErrors.fail((String)("Can not serialize object " + object));
            }
            return message;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not serialize object.", e);
        }
    }

    public static ResponseActions validate(Object response) {
        DefaultMessageContext messageContext = new DefaultMessageContext(messageFactory);
        messageContext.setResponse(ServerTestHelper.serialize(response));
        return ServerTestHelper.validate((MessageContext)messageContext);
    }

    public static ResponseActions validate(Object response, Object request) {
        DefaultMessageContext messageContext = new DefaultMessageContext(ServerTestHelper.serialize(request), messageFactory);
        messageContext.setResponse(ServerTestHelper.serialize(response));
        return ServerTestHelper.validate((MessageContext)messageContext);
    }

    public static ResponseActions validate(MessageContext messageContext) {
        return new MockWebServiceClientResponseActions(messageContext);
    }

    public static MessageHelper getMessageHelper() {
        return messageHelper;
    }

    public static void setMessageHelper(MessageHelper messageHelper) {
        ServerTestHelper.messageHelper = messageHelper;
    }

    static WebServiceMessageFactory getMessageFactory() {
        return messageFactory;
    }

    static void setMessageFactory(WebServiceMessageFactory messageFactory) {
        ServerTestHelper.messageFactory = messageFactory;
    }
}

