/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.io.IOException;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.transport.WebServiceMessageReceiver;

public class InterceptingTemplate {
    private final ClientInterceptor[] interceptors;

    public InterceptingTemplate(ClientInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public void interceptRequest(MessageContext messageContext, WebServiceMessageReceiver messageReceiver) throws Exception {
        int interceptorIndex = -1;
        if (this.interceptors != null) {
            for (int i = 0; i < this.interceptors.length; ++i) {
                interceptorIndex = i;
                if (!this.interceptors[i].handleRequest(messageContext)) break;
            }
        }
        if (!messageContext.hasResponse()) {
            messageReceiver.receive(messageContext);
        }
        if (messageContext.hasResponse()) {
            if (!this.hasFault(messageContext.getResponse())) {
                this.triggerHandleResponse(interceptorIndex, messageContext);
            } else {
                this.triggerHandleFault(interceptorIndex, messageContext);
            }
        }
    }

    protected boolean hasFault(WebServiceMessage response) throws IOException {
        if (response instanceof FaultAwareWebServiceMessage) {
            FaultAwareWebServiceMessage faultMessage = (FaultAwareWebServiceMessage)response;
            return faultMessage.hasFault();
        }
        return false;
    }

    private void triggerHandleResponse(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleResponse(messageContext); --i) {
            }
        }
    }

    private void triggerHandleFault(int interceptorIndex, MessageContext messageContext) {
        if (messageContext.hasResponse() && this.interceptors != null) {
            for (int i = interceptorIndex; i >= 0 && this.interceptors[i].handleFault(messageContext); --i) {
            }
        }
    }
}

