/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.matchers;

import java.io.InputStream;
import net.jadler.Request;
import net.jadler.matchers.RequestMatcher;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public class RawBodyRequestMatcher
extends RequestMatcher<byte[]> {
    protected RawBodyRequestMatcher(Matcher<byte[]> pred) {
        super(pred);
    }

    @Override
    protected byte[] retrieveValue(Request req) throws Exception {
        return IOUtils.toByteArray((InputStream)req.getBodyAsStream());
    }

    @Override
    protected String provideDescription() {
        return "raw body is";
    }

    @Factory
    public static RawBodyRequestMatcher requestRawBody(Matcher<byte[]> pred) {
        return new RawBodyRequestMatcher(pred);
    }
}

