/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.quidem;

import com.google.common.base.Throwables;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

class LimitWriter
extends FilterWriter {
    private int length;
    private final int maxLength;

    protected LimitWriter(Writer w, int maxLength) {
        super(w);
        this.maxLength = maxLength;
    }

    private int length() {
        return this.length;
    }

    @Override
    public void write(int c) throws IOException {
        int newLength = this.length() + 1;
        if (newLength <= this.maxLength) {
            super.write(c);
            ++this.length;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.length + len <= this.maxLength) {
            super.write(cbuf, off, len);
            this.length += len;
        } else if (this.length < this.maxLength) {
            super.write(cbuf, off, this.maxLength - this.length);
            this.length = this.maxLength;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.length + len <= this.maxLength) {
            super.write(str, off, len);
            this.length += len;
        } else if (this.length < this.maxLength) {
            super.write(str, off, this.maxLength - this.length);
            this.length = this.maxLength;
        }
    }

    public void ellipsis(String message) {
        if (this.length >= this.maxLength) {
            try {
                this.out.write(message);
                this.out.flush();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

