/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset.gsm;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import net.freeutils.charset.EscapedByteLookupCharset;
import net.freeutils.charset.gsm.GSMCharset;

public class PackedGSMCharset
extends GSMCharset {
    static final int BUFFER_SIZE = 256;
    static final byte CR = 13;
    final boolean padWithCR;

    protected PackedGSMCharset(String canonicalName, String[] aliases, int[] byteToChar, int[] byteToCharEscaped, int[][] charToByte, int[][] charToByteEscaped, boolean padWithCR) {
        super(canonicalName, aliases, byteToChar, byteToCharEscaped, charToByte, charToByteEscaped);
        this.padWithCR = padWithCR;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder((Charset)this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder((Charset)this);
    }

    public static byte[] unpack(byte[] in) {
        byte[] out = new byte[in.length * 8 / 7];
        int len = out.length;
        int current = 0;
        int bitpos = 0;
        for (int i = 0; i < len; ++i) {
            out[i] = (byte)((in[current] & 0xFF) >> bitpos & 0x7F);
            if (bitpos > 1) {
                int n = i;
                out[n] = (byte)(out[n] | (byte)(in[++current] << 8 - bitpos & 0x7F));
            } else if (bitpos == 1) {
                ++current;
            }
            bitpos = (bitpos + 7) % 8;
        }
        if (len % 8 == 0 && len > 0 && out[len - 1] == 0) {
            byte[] fixed = new byte[len - 1];
            System.arraycopy(out, 0, fixed, 0, len - 1);
            out = fixed;
        }
        return out;
    }

    public static byte[] pack(byte[] in) {
        byte[] out = new byte[(int)Math.ceil((float)(in.length * 7) / 8.0f)];
        int current = 0;
        int bitpos = 0;
        for (byte b : in) {
            b = (byte)(b & 0x7F);
            int n = current++;
            out[n] = (byte)(out[n] | b << bitpos);
            if (bitpos > 1) {
                int n2 = current;
                out[n2] = (byte)(out[n2] | b >> 8 - bitpos);
            } else if (bitpos == 1) {
                ++current;
            }
            bitpos = (bitpos + 7) % 8;
        }
        return out;
    }

    protected class Decoder
    extends EscapedByteLookupCharset.Decoder {
        int bitpos;
        byte current;
        byte prev;
        int unpackedCount;
        ByteBuffer buf;

        protected Decoder(Charset charset) {
            super(PackedGSMCharset.this, charset, 1.1428572f, 2.0f);
            this.buf = ByteBuffer.allocate(256);
            this.implReset();
        }

        protected void implReset() {
            this.bitpos = 0;
            this.current = 0;
            this.prev = 0;
            this.unpackedCount = 0;
            this.buf.limit(0);
        }

        protected CoderResult implFlush(CharBuffer out) {
            char c;
            int pos;
            int mod = this.unpackedCount % 8;
            if (mod <= 1 && (pos = out.position() - 1) > 0 && ((c = out.get(pos)) == '@' && !PackedGSMCharset.this.padWithCR && mod == 0 || c == '\r' && PackedGSMCharset.this.padWithCR && (mod == 0 || out.get(pos - 1) == '\r'))) {
                out.position(pos);
            }
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            CoderResult decodeResult;
            block2: {
                while (true) {
                    this.unpackedCount -= this.buf.remaining();
                    this.buf.compact();
                    CoderResult unpackResult = this.unpack(in, this.buf);
                    this.buf.flip();
                    if (!this.buf.hasRemaining()) {
                        return unpackResult;
                    }
                    this.unpackedCount += this.buf.remaining();
                    decodeResult = super.decodeLoop(this.buf, out);
                    if (!this.buf.hasRemaining() && !decodeResult.isError()) continue;
                    if (!decodeResult.isUnderflow()) break block2;
                    if (!in.hasRemaining() && !unpackResult.isOverflow()) break;
                }
                in.position(in.position() - 1);
                this.bitpos = (this.bitpos + 9) % 8;
                this.current = this.prev;
                this.buf.limit(this.buf.position());
                --this.unpackedCount;
            }
            return decodeResult;
        }

        protected CoderResult unpack(ByteBuffer in, ByteBuffer out) {
            int remaining = out.remaining();
            while (remaining-- > 0) {
                if (!in.hasRemaining() && this.bitpos != 1) {
                    return CoderResult.UNDERFLOW;
                }
                if (this.bitpos == 0) {
                    this.prev = this.current;
                    this.current = in.get();
                }
                byte b = (byte)((this.current & 0xFF) >> this.bitpos & 0x7F);
                if (this.bitpos >= 2) {
                    this.prev = this.current;
                    this.current = in.get();
                    b = (byte)(b | (byte)(this.current << 8 - this.bitpos & 0x7F));
                }
                this.bitpos = (this.bitpos + 7) % 8;
                out.put(b);
            }
            return CoderResult.OVERFLOW;
        }
    }

    protected class Encoder
    extends EscapedByteLookupCharset.Encoder {
        int bitpos;
        byte current;
        ByteBuffer buf;

        protected Encoder(Charset charset) {
            super(PackedGSMCharset.this, charset, 0.875f, 2.0f);
            this.buf = ByteBuffer.allocate(256);
            this.implReset();
        }

        protected void implReset() {
            this.bitpos = 0;
            this.current = 0;
            this.buf.limit(0);
        }

        protected CoderResult implFlush(ByteBuffer out) {
            CoderResult result = this.pack(this.buf, out);
            if (PackedGSMCharset.this.padWithCR && this.bitpos <= 1) {
                if (this.bitpos == 1) {
                    this.current = (byte)(this.current | 0x1A);
                } else if (out.position() > 0 && out.get(out.position() - 1) >>> 1 == 13) {
                    this.current = (byte)13;
                    this.bitpos = 7;
                }
            }
            if (this.bitpos != 0) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                out.put(this.current);
            }
            return result;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CoderResult result;
            do {
                if (this.buf.hasRemaining() && (result = this.pack(this.buf, out)) == CoderResult.OVERFLOW) {
                    return result;
                }
                this.buf.clear();
                result = super.encodeLoop(in, this.buf);
                this.buf.flip();
            } while (this.buf.hasRemaining() && !result.isError());
            return result;
        }

        protected CoderResult pack(ByteBuffer in, ByteBuffer out) {
            int remaining = in.remaining();
            while (remaining-- > 0) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                byte b = (byte)(in.get() & 0x7F);
                this.current = (byte)(this.current | b << this.bitpos);
                if (this.bitpos > 0) {
                    out.put(this.current);
                    this.current = (byte)(b >> 8 - this.bitpos);
                }
                this.bitpos = (this.bitpos + 7) % 8;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

