/*
 * Decompiled with CFR 0.152.
 */
package net.freeutils.charset;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.freeutils.charset.HPRoman8Charset;
import net.freeutils.charset.ISO88596Charset;
import net.freeutils.charset.ISO88598Charset;
import net.freeutils.charset.KOI8UCharset;
import net.freeutils.charset.KZ1048Charset;
import net.freeutils.charset.MIKCharset;
import net.freeutils.charset.UTF7Charset;
import net.freeutils.charset.UTF7OptionalCharset;
import net.freeutils.charset.gsm.CCGSMCharset;
import net.freeutils.charset.gsm.CCPackedGSMCharset;
import net.freeutils.charset.gsm.CRCCPackedGSMCharset;
import net.freeutils.charset.gsm.CRSCPackedGSMCharset;
import net.freeutils.charset.gsm.SCGSMCharset;
import net.freeutils.charset.gsm.SCPackedGSMCharset;
import net.freeutils.charset.iso646.ISO646CA2Charset;
import net.freeutils.charset.iso646.ISO646CACharset;
import net.freeutils.charset.iso646.ISO646CHCharset;
import net.freeutils.charset.iso646.ISO646CNCharset;
import net.freeutils.charset.iso646.ISO646CUCharset;
import net.freeutils.charset.iso646.ISO646DECharset;
import net.freeutils.charset.iso646.ISO646DKCharset;
import net.freeutils.charset.iso646.ISO646ES2Charset;
import net.freeutils.charset.iso646.ISO646ESCharset;
import net.freeutils.charset.iso646.ISO646FISECharset;
import net.freeutils.charset.iso646.ISO646FR1Charset;
import net.freeutils.charset.iso646.ISO646FRCharset;
import net.freeutils.charset.iso646.ISO646GBCharset;
import net.freeutils.charset.iso646.ISO646HUCharset;
import net.freeutils.charset.iso646.ISO646IECharset;
import net.freeutils.charset.iso646.ISO646INVCharset;
import net.freeutils.charset.iso646.ISO646IRVCharset;
import net.freeutils.charset.iso646.ISO646ISCharset;
import net.freeutils.charset.iso646.ISO646ITCharset;
import net.freeutils.charset.iso646.ISO646JAOCharset;
import net.freeutils.charset.iso646.ISO646JPCharset;
import net.freeutils.charset.iso646.ISO646KRCharset;
import net.freeutils.charset.iso646.ISO646MTCharset;
import net.freeutils.charset.iso646.ISO646NO2Charset;
import net.freeutils.charset.iso646.ISO646NOCharset;
import net.freeutils.charset.iso646.ISO646PT2Charset;
import net.freeutils.charset.iso646.ISO646PTCharset;
import net.freeutils.charset.iso646.ISO646SE2Charset;
import net.freeutils.charset.iso646.ISO646T61Charset;
import net.freeutils.charset.iso646.ISO646TWCharset;
import net.freeutils.charset.iso646.ISO646USCharset;
import net.freeutils.charset.iso646.ISO646YUCharset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharsetProvider
extends java.nio.charset.spi.CharsetProvider {
    static Map<String, Charset> nameToCharset;
    static Collection<Charset> charsets;

    @Override
    public Charset charsetForName(String charsetName) {
        Charset charset;
        if (nameToCharset == null) {
            this.init();
        }
        if ((charset = nameToCharset.get(charsetName.toLowerCase())) != null) {
            try {
                return (Charset)charset.getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Iterator<Charset> charsets() {
        if (charsets == null) {
            this.init();
        }
        return charsets.iterator();
    }

    void init() {
        Charset[] allCharsets = new Charset[]{new UTF7Charset(), new UTF7OptionalCharset(), new SCGSMCharset(), new CCGSMCharset(), new SCPackedGSMCharset(), new CCPackedGSMCharset(), new CRSCPackedGSMCharset(), new CRCCPackedGSMCharset(), new HPRoman8Charset(), new KOI8UCharset(), new KZ1048Charset(), new ISO88598Charset(), new ISO88596Charset(), new MIKCharset(), new ISO646CACharset(), new ISO646CA2Charset(), new ISO646CHCharset(), new ISO646CNCharset(), new ISO646CUCharset(), new ISO646DECharset(), new ISO646DKCharset(), new ISO646ESCharset(), new ISO646ES2Charset(), new ISO646FISECharset(), new ISO646FRCharset(), new ISO646FR1Charset(), new ISO646GBCharset(), new ISO646HUCharset(), new ISO646IECharset(), new ISO646INVCharset(), new ISO646IRVCharset(), new ISO646ISCharset(), new ISO646ITCharset(), new ISO646JAOCharset(), new ISO646JPCharset(), new ISO646KRCharset(), new ISO646MTCharset(), new ISO646NO2Charset(), new ISO646NOCharset(), new ISO646PTCharset(), new ISO646PT2Charset(), new ISO646SE2Charset(), new ISO646T61Charset(), new ISO646TWCharset(), new ISO646USCharset(), new ISO646YUCharset()};
        charsets = Collections.unmodifiableCollection(Arrays.asList(allCharsets));
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        for (Charset charset : allCharsets) {
            map.put(charset.name().toLowerCase(), charset);
            for (String alias : charset.aliases()) {
                map.put(alias.toLowerCase(), charset);
            }
        }
        nameToCharset = map;
    }
}

