/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import io.grpc.Server;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.devh.boot.grpc.server.event.GrpcServerShutdownEvent;
import net.devh.boot.grpc.server.event.GrpcServerStartedEvent;
import net.devh.boot.grpc.server.event.GrpcServerTerminatedEvent;
import net.devh.boot.grpc.server.serverfactory.GrpcServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;

public class GrpcServerLifecycle
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerLifecycle.class);
    private static AtomicInteger serverCounter = new AtomicInteger(-1);
    private final GrpcServerFactory factory;
    private final Duration shutdownGracePeriod;
    private final ApplicationEventPublisher eventPublisher;
    private Server server;

    public GrpcServerLifecycle(GrpcServerFactory factory, Duration shutdownGracePeriod, ApplicationEventPublisher eventPublisher) {
        this.factory = Objects.requireNonNull(factory, "factory");
        this.shutdownGracePeriod = Objects.requireNonNull(shutdownGracePeriod, "shutdownGracePeriod");
        this.eventPublisher = eventPublisher;
    }

    public void start() {
        try {
            this.createAndStartGrpcServer();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to start the grpc server", e);
        }
    }

    public void stop() {
        this.stopAndReleaseGrpcServer();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.server != null && !this.server.isShutdown();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isAutoStartup() {
        return true;
    }

    protected void createAndStartGrpcServer() throws IOException {
        if (this.server == null) {
            Server localServer;
            this.server = localServer = this.factory.createServer();
            localServer.start();
            String address = this.factory.getAddress();
            int port = this.factory.getPort();
            log.info("gRPC Server started, listening on address: {}, port: {}", (Object)address, (Object)port);
            this.eventPublisher.publishEvent((ApplicationEvent)new GrpcServerStartedEvent(this, localServer, address, port));
            Thread awaitThread = new Thread(() -> {
                try {
                    localServer.awaitTermination();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            awaitThread.setName("grpc-server-container-" + serverCounter.incrementAndGet());
            awaitThread.setDaemon(false);
            awaitThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAndReleaseGrpcServer() {
        Server localServer = this.server;
        if (localServer != null) {
            long millis = this.shutdownGracePeriod.toMillis();
            log.debug("Initiating gRPC server shutdown");
            this.eventPublisher.publishEvent((ApplicationEvent)new GrpcServerShutdownEvent(this, localServer));
            localServer.shutdown();
            try {
                if (millis > 0L) {
                    localServer.awaitTermination(millis, TimeUnit.MILLISECONDS);
                } else if (millis == 0L) {
                } else {
                    localServer.awaitTermination();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                localServer.shutdownNow();
                this.server = null;
            }
            log.info("Completed gRPC server shutdown");
            this.eventPublisher.publishEvent((ApplicationEvent)new GrpcServerTerminatedEvent(this, localServer));
        }
    }
}

