/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import net.devh.boot.grpc.server.config.ClientAuth;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.io.Resource;
import org.springframework.util.SocketUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(value="grpc.server")
public class GrpcServerProperties {
    public static final String ANY_IP_ADDRESS = "*";
    public static final String ANY_IPv4_ADDRESS = "0.0.0.0";
    public static final String ANY_IPv6_ADDRESS = "::";
    private String address = "*";
    private int port = 9090;
    private String inProcessName;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration shutdownGracePeriod = Duration.of(30L, ChronoUnit.SECONDS);
    private boolean enableKeepAlive = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime = Duration.of(2L, ChronoUnit.HOURS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout = Duration.of(20L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration permitKeepAliveTime = Duration.of(5L, ChronoUnit.MINUTES);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private boolean permitKeepAliveWithoutCalls = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionIdle = null;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionAge = null;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration maxConnectionAgeGrace = null;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = null;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMetadataSize = null;
    private boolean healthServiceEnabled = true;
    private boolean reflectionServiceEnabled = true;
    private final Security security = new Security();

    public int getPort() {
        if (this.port == 0) {
            this.port = SocketUtils.findAvailableTcpPort();
        }
        return this.port;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        if (maxInboundMessageSize == null || maxInboundMessageSize.toBytes() >= 0L) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        } else if (maxInboundMessageSize.toBytes() == -1L) {
            this.maxInboundMessageSize = DataSize.ofBytes((long)Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMessageSize: " + maxInboundMessageSize);
        }
    }

    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        if (maxInboundMetadataSize == null || maxInboundMetadataSize.toBytes() >= 0L) {
            this.maxInboundMetadataSize = maxInboundMetadataSize;
        } else if (maxInboundMetadataSize.toBytes() == -1L) {
            this.maxInboundMetadataSize = DataSize.ofBytes((long)Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMetadataSize: " + maxInboundMetadataSize);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getInProcessName() {
        return this.inProcessName;
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Duration getPermitKeepAliveTime() {
        return this.permitKeepAliveTime;
    }

    public boolean isPermitKeepAliveWithoutCalls() {
        return this.permitKeepAliveWithoutCalls;
    }

    public Duration getMaxConnectionIdle() {
        return this.maxConnectionIdle;
    }

    public Duration getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    public Duration getMaxConnectionAgeGrace() {
        return this.maxConnectionAgeGrace;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public boolean isHealthServiceEnabled() {
        return this.healthServiceEnabled;
    }

    public boolean isReflectionServiceEnabled() {
        return this.reflectionServiceEnabled;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setInProcessName(String inProcessName) {
        this.inProcessName = inProcessName;
    }

    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setPermitKeepAliveTime(Duration permitKeepAliveTime) {
        this.permitKeepAliveTime = permitKeepAliveTime;
    }

    public void setPermitKeepAliveWithoutCalls(boolean permitKeepAliveWithoutCalls) {
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
    }

    public void setMaxConnectionIdle(Duration maxConnectionIdle) {
        this.maxConnectionIdle = maxConnectionIdle;
    }

    public void setMaxConnectionAge(Duration maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
    }

    public void setMaxConnectionAgeGrace(Duration maxConnectionAgeGrace) {
        this.maxConnectionAgeGrace = maxConnectionAgeGrace;
    }

    public void setHealthServiceEnabled(boolean healthServiceEnabled) {
        this.healthServiceEnabled = healthServiceEnabled;
    }

    public void setReflectionServiceEnabled(boolean reflectionServiceEnabled) {
        this.reflectionServiceEnabled = reflectionServiceEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcServerProperties)) {
            return false;
        }
        GrpcServerProperties other = (GrpcServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        if (this.isPermitKeepAliveWithoutCalls() != other.isPermitKeepAliveWithoutCalls()) {
            return false;
        }
        if (this.isHealthServiceEnabled() != other.isHealthServiceEnabled()) {
            return false;
        }
        if (this.isReflectionServiceEnabled() != other.isReflectionServiceEnabled()) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$inProcessName = this.getInProcessName();
        String other$inProcessName = other.getInProcessName();
        if (this$inProcessName == null ? other$inProcessName != null : !this$inProcessName.equals(other$inProcessName)) {
            return false;
        }
        Duration this$shutdownGracePeriod = this.getShutdownGracePeriod();
        Duration other$shutdownGracePeriod = other.getShutdownGracePeriod();
        if (this$shutdownGracePeriod == null ? other$shutdownGracePeriod != null : !((Object)this$shutdownGracePeriod).equals(other$shutdownGracePeriod)) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Duration this$permitKeepAliveTime = this.getPermitKeepAliveTime();
        Duration other$permitKeepAliveTime = other.getPermitKeepAliveTime();
        if (this$permitKeepAliveTime == null ? other$permitKeepAliveTime != null : !((Object)this$permitKeepAliveTime).equals(other$permitKeepAliveTime)) {
            return false;
        }
        Duration this$maxConnectionIdle = this.getMaxConnectionIdle();
        Duration other$maxConnectionIdle = other.getMaxConnectionIdle();
        if (this$maxConnectionIdle == null ? other$maxConnectionIdle != null : !((Object)this$maxConnectionIdle).equals(other$maxConnectionIdle)) {
            return false;
        }
        Duration this$maxConnectionAge = this.getMaxConnectionAge();
        Duration other$maxConnectionAge = other.getMaxConnectionAge();
        if (this$maxConnectionAge == null ? other$maxConnectionAge != null : !((Object)this$maxConnectionAge).equals(other$maxConnectionAge)) {
            return false;
        }
        Duration this$maxConnectionAgeGrace = this.getMaxConnectionAgeGrace();
        Duration other$maxConnectionAgeGrace = other.getMaxConnectionAgeGrace();
        if (this$maxConnectionAgeGrace == null ? other$maxConnectionAgeGrace != null : !((Object)this$maxConnectionAgeGrace).equals(other$maxConnectionAgeGrace)) {
            return false;
        }
        DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
            return false;
        }
        DataSize this$maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        DataSize other$maxInboundMetadataSize = other.getMaxInboundMetadataSize();
        if (this$maxInboundMetadataSize == null ? other$maxInboundMetadataSize != null : !this$maxInboundMetadataSize.equals(other$maxInboundMetadataSize)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        result = result * 59 + (this.isPermitKeepAliveWithoutCalls() ? 79 : 97);
        result = result * 59 + (this.isHealthServiceEnabled() ? 79 : 97);
        result = result * 59 + (this.isReflectionServiceEnabled() ? 79 : 97);
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $inProcessName = this.getInProcessName();
        result = result * 59 + ($inProcessName == null ? 43 : $inProcessName.hashCode());
        Duration $shutdownGracePeriod = this.getShutdownGracePeriod();
        result = result * 59 + ($shutdownGracePeriod == null ? 43 : ((Object)$shutdownGracePeriod).hashCode());
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Duration $permitKeepAliveTime = this.getPermitKeepAliveTime();
        result = result * 59 + ($permitKeepAliveTime == null ? 43 : ((Object)$permitKeepAliveTime).hashCode());
        Duration $maxConnectionIdle = this.getMaxConnectionIdle();
        result = result * 59 + ($maxConnectionIdle == null ? 43 : ((Object)$maxConnectionIdle).hashCode());
        Duration $maxConnectionAge = this.getMaxConnectionAge();
        result = result * 59 + ($maxConnectionAge == null ? 43 : ((Object)$maxConnectionAge).hashCode());
        Duration $maxConnectionAgeGrace = this.getMaxConnectionAgeGrace();
        result = result * 59 + ($maxConnectionAgeGrace == null ? 43 : ((Object)$maxConnectionAgeGrace).hashCode());
        DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
        DataSize $maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        result = result * 59 + ($maxInboundMetadataSize == null ? 43 : $maxInboundMetadataSize.hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public String toString() {
        return "GrpcServerProperties(address=" + this.getAddress() + ", port=" + this.getPort() + ", inProcessName=" + this.getInProcessName() + ", shutdownGracePeriod=" + this.getShutdownGracePeriod() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", permitKeepAliveTime=" + this.getPermitKeepAliveTime() + ", permitKeepAliveWithoutCalls=" + this.isPermitKeepAliveWithoutCalls() + ", maxConnectionIdle=" + this.getMaxConnectionIdle() + ", maxConnectionAge=" + this.getMaxConnectionAge() + ", maxConnectionAgeGrace=" + this.getMaxConnectionAgeGrace() + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", maxInboundMetadataSize=" + this.getMaxInboundMetadataSize() + ", healthServiceEnabled=" + this.isHealthServiceEnabled() + ", reflectionServiceEnabled=" + this.isReflectionServiceEnabled() + ", security=" + this.getSecurity() + ")";
    }

    public static class Security {
        private boolean enabled = false;
        private Resource certificateChain = null;
        private Resource privateKey = null;
        private String privateKeyPassword = null;
        private String keyStoreFormat = "AUTODETECT";
        private Resource keyStore = null;
        private String keyStorePassword = null;
        private ClientAuth clientAuth = ClientAuth.NONE;
        private Resource trustCertCollection = null;
        private String trustStoreFormat = "AUTODETECT";
        private Resource trustStore = null;
        private String trustStorePassword = null;
        private List<String> ciphers = null;
        private String[] protocols = null;

        public void setCiphers(String ciphers) {
            this.ciphers = Arrays.asList(ciphers.split("[ :,]"));
        }

        public void setProtocols(String protocols) {
            this.protocols = protocols.split("[ :,]");
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Resource getCertificateChain() {
            return this.certificateChain;
        }

        public Resource getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }

        public String getKeyStoreFormat() {
            return this.keyStoreFormat;
        }

        public Resource getKeyStore() {
            return this.keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public Resource getTrustCertCollection() {
            return this.trustCertCollection;
        }

        public String getTrustStoreFormat() {
            return this.trustStoreFormat;
        }

        public Resource getTrustStore() {
            return this.trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public List<String> getCiphers() {
            return this.ciphers;
        }

        public String[] getProtocols() {
            return this.protocols;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setCertificateChain(Resource certificateChain) {
            this.certificateChain = certificateChain;
        }

        public void setPrivateKey(Resource privateKey) {
            this.privateKey = privateKey;
        }

        public void setPrivateKeyPassword(String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
        }

        public void setKeyStoreFormat(String keyStoreFormat) {
            this.keyStoreFormat = keyStoreFormat;
        }

        public void setKeyStore(Resource keyStore) {
            this.keyStore = keyStore;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public void setTrustCertCollection(Resource trustCertCollection) {
            this.trustCertCollection = trustCertCollection;
        }

        public void setTrustStoreFormat(String trustStoreFormat) {
            this.trustStoreFormat = trustStoreFormat;
        }

        public void setTrustStore(Resource trustStore) {
            this.trustStore = trustStore;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Resource this$certificateChain = this.getCertificateChain();
            Resource other$certificateChain = other.getCertificateChain();
            if (this$certificateChain == null ? other$certificateChain != null : !this$certificateChain.equals(other$certificateChain)) {
                return false;
            }
            Resource this$privateKey = this.getPrivateKey();
            Resource other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$privateKeyPassword = this.getPrivateKeyPassword();
            String other$privateKeyPassword = other.getPrivateKeyPassword();
            if (this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword)) {
                return false;
            }
            String this$keyStoreFormat = this.getKeyStoreFormat();
            String other$keyStoreFormat = other.getKeyStoreFormat();
            if (this$keyStoreFormat == null ? other$keyStoreFormat != null : !this$keyStoreFormat.equals(other$keyStoreFormat)) {
                return false;
            }
            Resource this$keyStore = this.getKeyStore();
            Resource other$keyStore = other.getKeyStore();
            if (this$keyStore == null ? other$keyStore != null : !this$keyStore.equals(other$keyStore)) {
                return false;
            }
            String this$keyStorePassword = this.getKeyStorePassword();
            String other$keyStorePassword = other.getKeyStorePassword();
            if (this$keyStorePassword == null ? other$keyStorePassword != null : !this$keyStorePassword.equals(other$keyStorePassword)) {
                return false;
            }
            ClientAuth this$clientAuth = this.getClientAuth();
            ClientAuth other$clientAuth = other.getClientAuth();
            if (this$clientAuth == null ? other$clientAuth != null : !((Object)((Object)this$clientAuth)).equals((Object)other$clientAuth)) {
                return false;
            }
            Resource this$trustCertCollection = this.getTrustCertCollection();
            Resource other$trustCertCollection = other.getTrustCertCollection();
            if (this$trustCertCollection == null ? other$trustCertCollection != null : !this$trustCertCollection.equals(other$trustCertCollection)) {
                return false;
            }
            String this$trustStoreFormat = this.getTrustStoreFormat();
            String other$trustStoreFormat = other.getTrustStoreFormat();
            if (this$trustStoreFormat == null ? other$trustStoreFormat != null : !this$trustStoreFormat.equals(other$trustStoreFormat)) {
                return false;
            }
            Resource this$trustStore = this.getTrustStore();
            Resource other$trustStore = other.getTrustStore();
            if (this$trustStore == null ? other$trustStore != null : !this$trustStore.equals(other$trustStore)) {
                return false;
            }
            String this$trustStorePassword = this.getTrustStorePassword();
            String other$trustStorePassword = other.getTrustStorePassword();
            if (this$trustStorePassword == null ? other$trustStorePassword != null : !this$trustStorePassword.equals(other$trustStorePassword)) {
                return false;
            }
            List<String> this$ciphers = this.getCiphers();
            List<String> other$ciphers = other.getCiphers();
            if (this$ciphers == null ? other$ciphers != null : !((Object)this$ciphers).equals(other$ciphers)) {
                return false;
            }
            return Arrays.deepEquals(this.getProtocols(), other.getProtocols());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Resource $certificateChain = this.getCertificateChain();
            result = result * 59 + ($certificateChain == null ? 43 : $certificateChain.hashCode());
            Resource $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $privateKeyPassword = this.getPrivateKeyPassword();
            result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
            String $keyStoreFormat = this.getKeyStoreFormat();
            result = result * 59 + ($keyStoreFormat == null ? 43 : $keyStoreFormat.hashCode());
            Resource $keyStore = this.getKeyStore();
            result = result * 59 + ($keyStore == null ? 43 : $keyStore.hashCode());
            String $keyStorePassword = this.getKeyStorePassword();
            result = result * 59 + ($keyStorePassword == null ? 43 : $keyStorePassword.hashCode());
            ClientAuth $clientAuth = this.getClientAuth();
            result = result * 59 + ($clientAuth == null ? 43 : ((Object)((Object)$clientAuth)).hashCode());
            Resource $trustCertCollection = this.getTrustCertCollection();
            result = result * 59 + ($trustCertCollection == null ? 43 : $trustCertCollection.hashCode());
            String $trustStoreFormat = this.getTrustStoreFormat();
            result = result * 59 + ($trustStoreFormat == null ? 43 : $trustStoreFormat.hashCode());
            Resource $trustStore = this.getTrustStore();
            result = result * 59 + ($trustStore == null ? 43 : $trustStore.hashCode());
            String $trustStorePassword = this.getTrustStorePassword();
            result = result * 59 + ($trustStorePassword == null ? 43 : $trustStorePassword.hashCode());
            List<String> $ciphers = this.getCiphers();
            result = result * 59 + ($ciphers == null ? 43 : ((Object)$ciphers).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProtocols());
            return result;
        }

        public String toString() {
            return "GrpcServerProperties.Security(enabled=" + this.isEnabled() + ", certificateChain=" + this.getCertificateChain() + ", privateKey=" + this.getPrivateKey() + ", privateKeyPassword=" + this.getPrivateKeyPassword() + ", keyStoreFormat=" + this.getKeyStoreFormat() + ", keyStore=" + this.getKeyStore() + ", keyStorePassword=" + this.getKeyStorePassword() + ", clientAuth=" + (Object)((Object)this.getClientAuth()) + ", trustCertCollection=" + this.getTrustCertCollection() + ", trustStoreFormat=" + this.getTrustStoreFormat() + ", trustStore=" + this.getTrustStore() + ", trustStorePassword=" + this.getTrustStorePassword() + ", ciphers=" + this.getCiphers() + ", protocols=" + Arrays.deepToString(this.getProtocols()) + ")";
        }
    }
}

