/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import io.grpc.ClientInterceptor;
import io.micrometer.core.instrument.binder.grpc.ObservationGrpcClientInterceptor;
import io.micrometer.observation.ObservationRegistry;
import net.devh.boot.grpc.client.interceptor.GrpcGlobalClientInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"management.tracing.grpc.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnBean(value={ObservationRegistry.class})
public class GrpcClientMicrometerTraceAutoConfiguration {
    @GrpcGlobalClientInterceptor
    @Order(value=2501)
    ClientInterceptor globalObservationClientInterceptorConfigurer(ObservationRegistry observations) {
        return new ObservationGrpcClientInterceptor(observations);
    }
}

