/*
 * Decompiled with CFR 0.152.
 */
package com.redis.cluster;

import com.redis.cluster.HashRing$;
import java.io.Serializable;
import java.util.zip.CRC32;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001B\u0013'\u00016B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t)\u0002\u0011\t\u0012)A\u0005\r\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003X\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d9\u0003A1A\u0005\u0002\u0005DaA\u001b\u0001!\u0002\u0013\u0011\u0007bB6\u0001\u0001\u0004%I\u0001\u001c\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u0019i\b\u0001)Q\u0005[\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0003\"CA-\u0001E\u0005I\u0011AA.\u0011%\t)\bAI\u0001\n\u0003\t9\bC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0011\u0002\u0002\"A\u00111\u0013\u0001\u0002\u0002\u0013\u0005a\u000bC\u0005\u0002\u0016\u0002\t\t\u0011\"\u0001\u0002\u0018\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003O\u0003\u0011\u0011!C\u0001\u0003SC\u0011\"!,\u0001\u0003\u0003%\t%a,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\tY\fAA\u0001\n\u0003\nilB\u0005\u0002B\u001a\n\t\u0011#\u0001\u0002D\u001aAQEJA\u0001\u0012\u0003\t)\r\u0003\u0004\\?\u0011\u0005\u0011\u0011\u001b\u0005\n\u0003o{\u0012\u0011!C#\u0003sC\u0011\"a5 \u0003\u0003%\t)!6\t\u0013\u0005\u0015x$!A\u0005\u0002\u0006\u001d\b\"CA\u0000?\u0005\u0005I\u0011\u0002B\u0001\u0005!A\u0015m\u001d5SS:<'BA\u0014)\u0003\u001d\u0019G.^:uKJT!!\u000b\u0016\u0002\u000bI,G-[:\u000b\u0003-\n1aY8n\u0007\u0001)\"AL&\u0014\t\u0001yS\u0007\u000f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A2\u0014BA\u001c2\u0005\u001d\u0001&o\u001c3vGR\u0004\"!O!\u000f\u0005izdBA\u001e?\u001b\u0005a$BA\u001f-\u0003\u0019a$o\\8u}%\t!'\u0003\u0002Ac\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"D\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0001\u0015'A\u0003o_\u0012,7/F\u0001G!\rIt)S\u0005\u0003\u0011\u000e\u0013A\u0001T5tiB\u0011!j\u0013\u0007\u0001\t\u0015a\u0005A1\u0001N\u0005\u0005!\u0016C\u0001(R!\t\u0001t*\u0003\u0002Qc\t9aj\u001c;iS:<\u0007C\u0001\u0019S\u0013\t\u0019\u0016GA\u0002B]f\faA\\8eKN\u0004\u0013\u0001\u0003:fa2L7-Y:\u0016\u0003]\u0003\"\u0001\r-\n\u0005e\u000b$aA%oi\u0006I!/\u001a9mS\u000e\f7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007u{\u0006\rE\u0002_\u0001%k\u0011A\n\u0005\u0006\t\u0016\u0001\rA\u0012\u0005\u0006+\u0016\u0001\raV\u000b\u0002EB\u00191\r[%\u000e\u0003\u0011T!!\u001a4\u0002\u000f5,H/\u00192mK*\u0011q-M\u0001\u000bG>dG.Z2uS>t\u0017BA5e\u0005-\t%O]1z\u0005V4g-\u001a:\u0002\u0011\rdWo\u001d;fe\u0002\nAA]5oOV\tQ\u000e\u0005\u0003ocNLU\"A8\u000b\u0005A4\u0017!C5n[V$\u0018M\u00197f\u0013\t\u0011xNA\u0004Ue\u0016,W*\u00199\u0011\u0005A\"\u0018BA;2\u0005\u0011auN\\4\u0002\u0011ILgnZ0%KF$\"\u0001_>\u0011\u0005AJ\u0018B\u0001>2\u0005\u0011)f.\u001b;\t\u000fqL\u0011\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002\u000bILgn\u001a\u0011\u0002\u000f\u0005$GMT8eKR\u0019\u00010!\u0001\t\r\u0005\r1\u00021\u0001J\u0003\u0011qw\u000eZ3\u0002\u0017I,\u0007\u000f\\1dK:{G-\u001a\u000b\u0005\u0003\u0013\ty\u0001\u0005\u00031\u0003\u0017I\u0015bAA\u0007c\t1q\n\u001d;j_:Da!a\u0001\r\u0001\u0004I\u0015A\u0003:f[>4XMT8eKR\u0019\u00010!\u0006\t\r\u0005\rQ\u00021\u0001J\u0003\u001d9W\r\u001e(pI\u0016$2!SA\u000e\u0011\u001d\tiB\u0004a\u0001\u0003?\t1a[3z!\u0015I\u0014\u0011EA\u0013\u0013\r\t\u0019c\u0011\u0002\u0004'\u0016\f\bc\u0001\u0019\u0002(%\u0019\u0011\u0011F\u0019\u0003\t\tKH/Z\u0001\u0012G\u0006d7-\u001e7bi\u0016\u001c\u0005.Z2lgVlGcA:\u00020!9\u0011\u0011G\bA\u0002\u0005}\u0011!\u0002<bYV,\u0017aB5t\u000b6\u0004H/_\u000b\u0003\u0003o\u00012\u0001MA\u001d\u0013\r\tY$\r\u0002\b\u0005>|G.Z1o\u0003-qw\u000eZ3ICNDgi\u001c:\u0015\u000bM\f\t%a\u0011\t\r\u0005\r\u0011\u00031\u0001J\u0011\u0019\t)%\u0005a\u0001/\u00069!/\u001a9mS\u000e\f\u0017\u0001B2paf,B!a\u0013\u0002RQ1\u0011QJA*\u0003/\u0002BA\u0018\u0001\u0002PA\u0019!*!\u0015\u0005\u000b1\u0013\"\u0019A'\t\u0011\u0011\u0013\u0002\u0013!a\u0001\u0003+\u0002B!O$\u0002P!9QK\u0005I\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0003;\n\u0019(\u0006\u0002\u0002`)\u001aa)!\u0019,\u0005\u0005\r\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001c2\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\n9GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Q\u0001T\nC\u00025\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u0002z\u0005uTCAA>U\r9\u0016\u0011\r\u0003\u0006\u0019R\u0011\r!T\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0006!!.\u0019<b\u0013\u0011\t\t*a\"\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!UAM\u0011\u001dax#!AA\u0002]\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003?\u0003R!!)\u0002$Fk\u0011AZ\u0005\u0004\u0003K3'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u000e\u0002,\"9A0GA\u0001\u0002\u0004\t\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a!\u00022\"9APGA\u0001\u0002\u00049\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\u000ba!Z9vC2\u001cH\u0003BA\u001c\u0003\u007fCq\u0001`\u000f\u0002\u0002\u0003\u0007\u0011+\u0001\u0005ICND'+\u001b8h!\tqvd\u0005\u0003 _\u0005\u001d\u0007\u0003BAe\u0003\u001fl!!a3\u000b\t\u00055\u00171R\u0001\u0003S>L1AQAf)\t\t\u0019-A\u0003baBd\u00170\u0006\u0003\u0002X\u0006uGCBAm\u0003?\f\u0019\u000f\u0005\u0003_\u0001\u0005m\u0007c\u0001&\u0002^\u0012)AJ\tb\u0001\u001b\"1AI\ta\u0001\u0003C\u0004B!O$\u0002\\\")QK\ta\u0001/\u00069QO\\1qa2LX\u0003BAu\u0003o$B!a;\u0002zB)\u0001'a\u0003\u0002nB1\u0001'a<\u0002t^K1!!=2\u0005\u0019!V\u000f\u001d7feA!\u0011hRA{!\rQ\u0015q\u001f\u0003\u0006\u0019\u000e\u0012\r!\u0014\u0005\n\u0003w\u001c\u0013\u0011!a\u0001\u0003{\f1\u0001\u001f\u00131!\u0011q\u0006!!>\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\u0001\u0003BAC\u0005\u000bIAAa\u0002\u0002\b\n1qJ\u00196fGR\u0004")
public class HashRing<T>
implements Product,
Serializable {
    private final List<T> nodes;
    private final int replicas;
    private final ArrayBuffer<T> cluster;
    private TreeMap<Object, T> ring;

    public static <T> Option<Tuple2<List<T>, Object>> unapply(HashRing<T> hashRing) {
        return HashRing$.MODULE$.unapply(hashRing);
    }

    public static <T> HashRing<T> apply(List<T> list, int n) {
        return HashRing$.MODULE$.apply(list, n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public List<T> nodes() {
        return this.nodes;
    }

    public int replicas() {
        return this.replicas;
    }

    public ArrayBuffer<T> cluster() {
        return this.cluster;
    }

    private TreeMap<Object, T> ring() {
        return this.ring;
    }

    private void ring_$eq(TreeMap<Object, T> x$1) {
        this.ring = x$1;
    }

    public void addNode(T node) {
        this.cluster().$plus$eq(node);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)replica -> this.ring_$eq((TreeMap)this.ring().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica))), node))));
    }

    public Option<T> replaceNode(T node) {
        ObjectRef replacedNode = ObjectRef.create((Object)None$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cluster().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block0: {
                if (!this.cluster().apply(i).toString().equals(node.toString())) break block0;
                replacedNode$1.elem = new Some(this.cluster().apply(i));
                this.cluster().update(i, node);
            }
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)replica -> this.ring_$eq((TreeMap)this.ring().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica))), node))));
        return (Option)replacedNode.elem;
    }

    public void removeNode(T node) {
        this.cluster().$minus$eq(node);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.replicas()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)replica -> this.ring_$eq((TreeMap)this.ring().$minus((Object)BoxesRunTime.boxToLong((long)this.nodeHashFor(node, replica)))));
    }

    public T getNode(Seq<Object> key) {
        if (this.isEmpty()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Can't get node for [%s] from an empty ring"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        long crc = this.calculateChecksum(key);
        return (T)this.ring().getOrElse((Object)BoxesRunTime.boxToLong((long)crc), (Function0 & Serializable)() -> this.nextClockwise$1(crc));
    }

    public long calculateChecksum(Seq<Object> value) {
        CRC32 checksum = new CRC32();
        checksum.update((byte[])value.toArray((ClassTag)ClassTag$.MODULE$.Byte()));
        return checksum.getValue();
    }

    public boolean isEmpty() {
        return this.ring().isEmpty();
    }

    private long nodeHashFor(T node, int replica) {
        return this.calculateChecksum((Seq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.byteArrayOps(new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(node), ":")).append(replica).toString().getBytes("UTF-8"))));
    }

    public <T> HashRing<T> copy(List<T> nodes, int replicas) {
        return new HashRing<T>(nodes, replicas);
    }

    public <T> List<T> copy$default$1() {
        return this.nodes();
    }

    public <T> int copy$default$2() {
        return this.replicas();
    }

    public String productPrefix() {
        return "HashRing";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.nodes();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.replicas());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HashRing;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "nodes";
                break;
            }
            case 1: {
                string = "replicas";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.nodes()));
        n = Statics.mix((int)n, (int)this.replicas());
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HashRing)) return false;
        boolean bl = true;
        if (!bl) return false;
        HashRing hashRing = (HashRing)x$1;
        if (this.replicas() != hashRing.replicas()) return false;
        List<T> list = this.nodes();
        List<T> list2 = hashRing.nodes();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!hashRing.canEqual(this)) return false;
        return true;
    }

    private final Object nextClockwise$1(long crc$1) {
        Tuple2 tuple2 = (Tuple2)this.ring().rangeImpl((Option)new Some((Object)BoxesRunTime.boxToLong((long)crc$1)), (Option)None$.MODULE$).headOption().getOrElse((Function0 & Serializable)() -> this.ring().head());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long ringKey = tuple2._1$mcJ$sp();
        Object node = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)ringKey), node);
        Tuple2 tuple23 = tuple22;
        long ringKey2 = tuple23._1$mcJ$sp();
        Object node2 = tuple23._2();
        return node2;
    }

    public HashRing(List<T> nodes, int replicas) {
        this.nodes = nodes;
        this.replicas = replicas;
        Product.$init$((Product)this);
        this.cluster = new ArrayBuffer();
        this.ring = (TreeMap)TreeMap$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.Long$.MODULE$);
        nodes.foreach((Function1 & Serializable)x$1 -> {
            this.addNode(x$1);
            return BoxedUnit.UNIT;
        });
    }
}

