/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.RandomString;

public abstract class InvocationHandlerAdapter
implements Implementation {
    private static final TypeDescription.Generic INVOCATION_HANDLER_TYPE = new TypeDescription.Generic.OfNonGenericType.ForLoadedType(InvocationHandler.class);
    private static final boolean NO_CACHING = false;
    protected static final boolean CACHING = true;
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods, Assigner assigner) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = assigner;
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%s", "invocationHandler", RandomString.hashOf(invocationHandler.hashCode())));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForInstance(fieldName, true, Assigner.DEFAULT, invocationHandler);
    }

    public static InvocationHandlerAdapter toField(String name) {
        return InvocationHandlerAdapter.toField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
    }

    public static InvocationHandlerAdapter toField(String name, FieldLocator.Factory fieldLocatorFactory) {
        return new ForField(name, true, Assigner.DEFAULT, fieldLocatorFactory);
    }

    private List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList.Generic parameterTypes = instrumentedMethod.getParameters().asTypeList();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        int currentIndex = 1;
        for (TypeDescription.Generic parameterType : parameterTypes) {
            instruction.add(new StackManipulation.Compound(MethodVariableAccess.of(parameterType).loadOffset(currentIndex), this.assigner.assign(parameterType, TypeDescription.Generic.OBJECT, Assigner.Typing.STATIC)));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract AssignerConfigurable withoutMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, StackManipulation preparingManipulation, FieldDescription fieldDescription) {
        if (instrumentedMethod.isStatic()) {
            throw new IllegalStateException("It is not possible to apply an invocation handler onto the static method " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField(fieldDescription).getter(), MethodVariableAccess.REFERENCE.loadOffset(0), this.cacheMethods ? MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()).cached() : MethodConstant.forMethod((MethodDescription.InDefinedShape)instrumentedMethod.asDefined()), ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(this.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke((MethodDescription)INVOCATION_HANDLER_TYPE.getDeclaredMethods().getOnly()), this.assigner.assign(TypeDescription.Generic.OBJECT, instrumentedMethod.getReturnType(), Assigner.Typing.DYNAMIC), MethodReturn.of(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InvocationHandlerAdapter that = (InvocationHandlerAdapter)other;
        return this.cacheMethods == that.cacheMethods && this.assigner.equals(that.assigner) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + (this.cacheMethods ? 1 : 0);
        return result;
    }

    protected static class ForField
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        private final FieldLocator.Factory fieldLocatorFactory;

        protected ForField(String fieldName, boolean cacheMethods, Assigner assigner, FieldLocator.Factory fieldLocatorFactory) {
            super(fieldName, cacheMethods, assigner);
            this.fieldLocatorFactory = fieldLocatorFactory;
        }

        @Override
        public AssignerConfigurable withoutMethodCache() {
            return new ForField(this.fieldName, false, this.assigner, this.fieldLocatorFactory);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForField(this.fieldName, this.cacheMethods, assigner, this.fieldLocatorFactory);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(implementationTarget.getInstrumentedType()).locate(this.fieldName);
            if (!resolution.isResolved()) {
                throw new IllegalStateException("Could not find a field named '" + this.fieldName + "' for " + implementationTarget.getInstrumentedType());
            }
            if (!resolution.getField().getType().asErasure().isAssignableTo(InvocationHandler.class)) {
                throw new IllegalStateException("Field " + resolution.getField() + " does not declare a type that is assignable to invocation handler");
            }
            return new Appender(implementationTarget.getInstrumentedType(), resolution.getField());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ForField forField = (ForField)object;
            return this.fieldLocatorFactory.equals(forField.fieldLocatorFactory);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.fieldLocatorFactory.hashCode();
            return result;
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForField{fieldName=" + this.fieldName + "cacheMethods=" + this.cacheMethods + "fieldLocatorFactory=" + this.fieldLocatorFactory + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;
            private final FieldDescription fieldDescription;

            protected Appender(TypeDescription instrumentedType, FieldDescription fieldDescription) {
                this.instrumentedType = instrumentedType;
                this.fieldDescription = fieldDescription;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForField.this.apply(methodVisitor, implementationContext, instrumentedMethod, this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.REFERENCE.loadOffset(0), this.fieldDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && this.fieldDescription.equals(((Appender)other).fieldDescription) && ForField.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForField.this;
            }

            public int hashCode() {
                return 31 * (31 * ForField.this.hashCode() + this.instrumentedType.hashCode()) + this.fieldDescription.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForField.Appender{invocationHandlerAdapter=" + ForField.this + "instrumentedType=" + this.instrumentedType + "fieldDescription=" + this.fieldDescription + '}';
            }
        }
    }

    protected static class ForInstance
    extends InvocationHandlerAdapter
    implements AssignerConfigurable {
        private static final String PREFIX = "invocationHandler";
        protected final InvocationHandler invocationHandler;

        protected ForInstance(String fieldName, boolean cacheMethods, Assigner assigner, InvocationHandler invocationHandler) {
            super(fieldName, cacheMethods, assigner);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public AssignerConfigurable withoutMethodCache() {
            return new ForInstance(this.fieldName, false, this.assigner, this.invocationHandler);
        }

        @Override
        public Implementation withAssigner(Assigner assigner) {
            return new ForInstance(this.fieldName, this.cacheMethods, assigner, this.invocationHandler);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, INVOCATION_HANDLER_TYPE)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.invocationHandler.equals(((ForInstance)other).invocationHandler) && this.fieldName.equals(((ForInstance)other).fieldName);
        }

        @Override
        public int hashCode() {
            return 31 * (31 * super.hashCode() + this.invocationHandler.hashCode()) + this.fieldName.hashCode();
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForInstance{fieldName=" + this.fieldName + ", cacheMethods=" + this.cacheMethods + ", invocationHandler=" + this.invocationHandler + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForInstance.this.apply(methodVisitor, implementationContext, instrumentedMethod, StackManipulation.Trivial.INSTANCE, (FieldDescription)((FieldList)this.instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForInstance.this.fieldName).and(ElementMatchers.genericFieldType(INVOCATION_HANDLER_TYPE)))).getOnly());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstance.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstance.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForInstance.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForInstance.Appender{invocationHandlerAdapter=" + ForInstance.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1);
    }
}

