/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.FilterableList;

public interface MethodGraph {
    public Node locate(MethodDescription.SignatureToken var1);

    public NodeList listNodes();

    public static class Simple
    implements MethodGraph {
        private final LinkedHashMap<MethodDescription.SignatureToken, Node> nodes;

        public Simple(LinkedHashMap<MethodDescription.SignatureToken, Node> nodes) {
            this.nodes = nodes;
        }

        public static MethodGraph of(List<? extends MethodDescription> methodDescriptions) {
            LinkedHashMap<MethodDescription.SignatureToken, Node> nodes = new LinkedHashMap<MethodDescription.SignatureToken, Node>();
            for (MethodDescription methodDescription : methodDescriptions) {
                nodes.put(methodDescription.asSignatureToken(), new Node.Simple(methodDescription));
            }
            return new Simple(nodes);
        }

        @Override
        public Node locate(MethodDescription.SignatureToken token) {
            Node node = this.nodes.get(token);
            return node == null ? Node.Unresolved.INSTANCE : node;
        }

        @Override
        public NodeList listNodes() {
            return new NodeList(new ArrayList<Node>(this.nodes.values()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.nodes.equals(((Simple)other).nodes);
        }

        public int hashCode() {
            return this.nodes.hashCode();
        }

        public String toString() {
            return "MethodGraph.Simple{nodes=" + this.nodes + '}';
        }
    }

    public static class NodeList
    extends FilterableList.AbstractBase<Node, NodeList> {
        private final List<? extends Node> nodes;

        public NodeList(List<? extends Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Node get(int index) {
            return this.nodes.get(index);
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        @Override
        protected NodeList wrap(List<Node> values) {
            return new NodeList(values);
        }

        public MethodList<?> asMethodList() {
            ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>(this.size());
            for (Node node : this.nodes) {
                methodDescriptions.add(node.getRepresentative());
            }
            return new MethodList.Explicit(methodDescriptions);
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface Compiler {
        public static final Compiler DEFAULT = Default.forJavaHierarchy();

        public Linked compile(TypeDescription var1);

        public Linked compile(TypeDefinition var1, TypeDescription var2);

        public static class Default<T>
        extends AbstractBase {
            private final Harmonizer<T> harmonizer;
            private final Merger merger;

            protected Default(Harmonizer<T> harmonizer, Merger merger) {
                this.harmonizer = harmonizer;
                this.merger = merger;
            }

            public static <S> Compiler of(Harmonizer<S> harmonizer, Merger merger) {
                return new Default<S>(harmonizer, merger);
            }

            public static Compiler forJavaHierarchy() {
                return Default.of(Harmonizer.ForJavaMethod.INSTANCE, Merger.Directional.LEFT);
            }

            public static Compiler forJVMHierarchy() {
                return Default.of(Harmonizer.ForJVMMethod.INSTANCE, Merger.Directional.LEFT);
            }

            @Override
            public Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
                HashMap<TypeDefinition, Key.Store<T>> snapshots = new HashMap<TypeDefinition, Key.Store<T>>();
                Key.Store<T> rootStore = this.doAnalyze(typeDefinition, snapshots, ElementMatchers.isVirtual().and(ElementMatchers.isVisibleTo(viewPoint)));
                TypeDescription.Generic superClass = typeDefinition.getSuperClass();
                TypeList.Generic interfaceTypes = typeDefinition.getInterfaces();
                HashMap<TypeDescription, MethodGraph> interfaceGraphs = new HashMap<TypeDescription, MethodGraph>();
                for (TypeDescription.Generic interfaceType : interfaceTypes) {
                    interfaceGraphs.put(interfaceType.asErasure(), ((Key.Store)snapshots.get(interfaceType)).asGraph(this.merger));
                }
                return new Linked.Delegation(rootStore.asGraph(this.merger), superClass == null ? Empty.INSTANCE : ((Key.Store)snapshots.get(superClass)).asGraph(this.merger), interfaceGraphs);
            }

            protected Key.Store<T> analyze(TypeDefinition typeDefinition, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                Key.Store<T> store = snapshots.get(typeDefinition);
                if (store == null) {
                    store = this.doAnalyze(typeDefinition, snapshots, relevanceMatcher);
                    snapshots.put(typeDefinition, store);
                }
                return store;
            }

            protected Key.Store<T> analyzeNullable(TypeDefinition typeDefinition, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                return typeDefinition == null ? new Key.Store() : this.analyze(typeDefinition, snapshots, relevanceMatcher);
            }

            protected Key.Store<T> doAnalyze(TypeDefinition typeDefinition, Map<TypeDefinition, Key.Store<T>> snapshots, ElementMatcher<? super MethodDescription> relevanceMatcher) {
                Key.Store<T> store = this.analyzeNullable(typeDefinition.getSuperClass(), snapshots, relevanceMatcher);
                Key.Store<T> interfaceStore = new Key.Store<T>();
                for (TypeDescription.Generic interfaceType : typeDefinition.getInterfaces()) {
                    interfaceStore = interfaceStore.combineWith(this.analyze(interfaceType, snapshots, relevanceMatcher));
                }
                store = store.inject(interfaceStore);
                for (MethodDescription methodDescription : (MethodList)typeDefinition.getDeclaredMethods().filter(relevanceMatcher)) {
                    store = store.registerTopLevel(methodDescription, this.harmonizer);
                }
                return store;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.harmonizer.equals(((Default)other).harmonizer) && this.merger.equals(((Default)other).merger);
            }

            public int hashCode() {
                return this.harmonizer.hashCode() + 31 * this.merger.hashCode();
            }

            public String toString() {
                return "MethodGraph.Compiler.Default{harmonizer=" + this.harmonizer + ", merger=" + this.merger + '}';
            }

            protected static abstract class Key<S> {
                protected final String internalName;

                protected Key(String internalName) {
                    this.internalName = internalName;
                }

                protected abstract Set<S> getIdentifiers();

                public boolean equals(Object other) {
                    return other == this || other instanceof Key && this.internalName.equals(((Key)other).internalName) && !Collections.disjoint(this.getIdentifiers(), ((Key)other).getIdentifiers());
                }

                public int hashCode() {
                    return this.internalName.hashCode();
                }

                protected static class Store<V> {
                    private final LinkedHashMap<Harmonized<V>, Entry<V>> entries;

                    protected Store() {
                        this(new LinkedHashMap<Harmonized<V>, Entry<V>>());
                    }

                    private Store(LinkedHashMap<Harmonized<V>, Entry<V>> entries) {
                        this.entries = entries;
                    }

                    private static <W> Entry<W> combine(Entry<W> left, Entry<W> right) {
                        Set<MethodDescription> leftMethods = left.getCandidates();
                        Set<MethodDescription> rightMethods = right.getCandidates();
                        LinkedHashSet<MethodDescription> combined = new LinkedHashSet<MethodDescription>(leftMethods.size() + rightMethods.size());
                        combined.addAll(leftMethods);
                        combined.addAll(rightMethods);
                        block0: for (MethodDescription leftMethod : leftMethods) {
                            MethodDescription rightMethod;
                            TypeDescription rightType;
                            TypeDescription leftType = leftMethod.getDeclaringType().asErasure();
                            Iterator<MethodDescription> iterator = rightMethods.iterator();
                            while (iterator.hasNext() && !leftType.equals(rightType = (rightMethod = iterator.next()).getDeclaringType().asErasure())) {
                                if (leftType.isAssignableTo(rightType)) {
                                    combined.remove(rightMethod);
                                    continue block0;
                                }
                                if (!leftType.isAssignableFrom(rightType)) continue;
                                combined.remove(leftMethod);
                                continue block0;
                            }
                        }
                        Harmonized<W> key = left.getKey().combineWith(right.getKey());
                        Visibility visibility = left.getVisibility().expandTo(right.getVisibility());
                        return combined.size() == 1 ? new Entry.Resolved<W>(key, (MethodDescription)combined.iterator().next(), visibility, false) : new Entry.Ambiguous<W>(key, combined, visibility);
                    }

                    protected Store<V> registerTopLevel(MethodDescription methodDescription, Harmonizer<V> harmonizer) {
                        LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>> entries = new LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>>(this.entries);
                        Harmonized<V> key = Harmonized.of(methodDescription, harmonizer);
                        Entry<Object> currentEntry = (Entry<Object>)entries.remove(key);
                        Entry<V> extendedEntry = (currentEntry == null ? new Entry.Initial<V>(key) : currentEntry).extendBy(methodDescription, harmonizer);
                        entries.put(extendedEntry.getKey(), extendedEntry);
                        return new Store<V>(entries);
                    }

                    protected Store<V> combineWith(Store<V> store) {
                        Store<V> combinedStore = this;
                        for (Entry<V> entry : store.entries.values()) {
                            combinedStore = combinedStore.combineWith(entry);
                        }
                        return combinedStore;
                    }

                    protected Store<V> combineWith(Entry<V> entry) {
                        LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>> entries = new LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>>(this.entries);
                        Entry previousEntry = (Entry)entries.remove(entry.getKey());
                        Entry<V> injectedEntry = previousEntry == null ? entry : Store.combine(previousEntry, entry);
                        entries.put(injectedEntry.getKey(), injectedEntry);
                        return new Store<V>(entries);
                    }

                    protected Store<V> inject(Store<V> store) {
                        Store<V> injectedStore = this;
                        for (Entry<V> entry : store.entries.values()) {
                            injectedStore = injectedStore.inject(entry);
                        }
                        return injectedStore;
                    }

                    protected Store<V> inject(Entry<V> entry) {
                        LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>> entries = new LinkedHashMap<Harmonized<Entry<Entry<Entry<V>>>>, Entry<Entry<Entry<Entry<V>>>>>(this.entries);
                        Entry dominantEntry = (Entry)entries.remove(entry.getKey());
                        Entry<V> injectedEntry = dominantEntry == null ? entry : dominantEntry.inject(entry.getKey(), entry.getVisibility());
                        entries.put(injectedEntry.getKey(), injectedEntry);
                        return new Store<V>(entries);
                    }

                    protected MethodGraph asGraph(Merger merger) {
                        LinkedHashMap<Key<MethodDescription.TypeToken>, Node> entries = new LinkedHashMap<Key<MethodDescription.TypeToken>, Node>();
                        for (Entry<V> entry : this.entries.values()) {
                            Node node = entry.asNode(merger);
                            entries.put(entry.getKey().detach(node.getRepresentative().asTypeToken()), node);
                        }
                        return new Graph(entries);
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Store)other).entries);
                    }

                    public int hashCode() {
                        return this.entries.hashCode();
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Key.Store{entries=" + this.entries + '}';
                    }

                    protected static class Graph
                    implements MethodGraph {
                        private final LinkedHashMap<Key<MethodDescription.TypeToken>, Node> entries;

                        protected Graph(LinkedHashMap<Key<MethodDescription.TypeToken>, Node> entries) {
                            this.entries = entries;
                        }

                        @Override
                        public Node locate(MethodDescription.SignatureToken token) {
                            Node node = this.entries.get(Detached.of(token));
                            return node == null ? Node.Unresolved.INSTANCE : node;
                        }

                        @Override
                        public NodeList listNodes() {
                            return new NodeList(new ArrayList<Node>(this.entries.values()));
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Graph)other).entries);
                        }

                        public int hashCode() {
                            return this.entries.hashCode();
                        }

                        public String toString() {
                            return "MethodGraph.Compiler.Default.Key.Store.Graph{entries=" + this.entries + '}';
                        }
                    }

                    protected static interface Entry<W> {
                        public Harmonized<W> getKey();

                        public Set<MethodDescription> getCandidates();

                        public Visibility getVisibility();

                        public Entry<W> extendBy(MethodDescription var1, Harmonizer<W> var2);

                        public Entry<W> inject(Harmonized<W> var1, Visibility var2);

                        public Node asNode(Merger var1);

                        public static class Ambiguous<U>
                        implements Entry<U> {
                            private final Harmonized<U> key;
                            private final LinkedHashSet<MethodDescription> methodDescriptions;
                            private final Visibility visibility;

                            protected Ambiguous(Harmonized<U> key, LinkedHashSet<MethodDescription> methodDescriptions, Visibility visibility) {
                                this.key = key;
                                this.methodDescriptions = methodDescriptions;
                                this.visibility = visibility;
                            }

                            protected static <Q> Entry<Q> of(Harmonized<Q> key, MethodDescription left, MethodDescription right, Visibility visibility) {
                                visibility = visibility.expandTo(left.getVisibility()).expandTo(right.getVisibility());
                                return left.isBridge() ^ right.isBridge() ? new Resolved<Q>(key, left.isBridge() ? right : left, visibility, false) : new Ambiguous<Q>(key, new LinkedHashSet<MethodDescription>(Arrays.asList(left, right)), visibility);
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                return this.key;
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                return this.methodDescriptions;
                            }

                            @Override
                            public Visibility getVisibility() {
                                return this.visibility;
                            }

                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                Harmonized<U> key = this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), harmonizer);
                                LinkedHashSet<MethodDescription> methodDescriptions = new LinkedHashSet<MethodDescription>(this.methodDescriptions.size() + 1);
                                TypeDescription declaringType = methodDescription.getDeclaringType().asErasure();
                                boolean bridge = methodDescription.isBridge();
                                Visibility visibility = this.visibility;
                                for (MethodDescription extendedMethod : this.methodDescriptions) {
                                    if (extendedMethod.getDeclaringType().asErasure().equals(declaringType)) {
                                        if (extendedMethod.isBridge() ^ bridge) {
                                            methodDescriptions.add(bridge ? extendedMethod : methodDescription);
                                        } else {
                                            methodDescriptions.add(methodDescription);
                                            methodDescriptions.add(extendedMethod);
                                        }
                                    }
                                    visibility = visibility.expandTo(extendedMethod.getVisibility());
                                }
                                if (methodDescriptions.isEmpty()) {
                                    return new Resolved<U>(key, methodDescription, visibility, bridge);
                                }
                                if (methodDescriptions.size() == 1) {
                                    return new Resolved<U>(key, (MethodDescription)methodDescriptions.iterator().next(), visibility, false);
                                }
                                return new Ambiguous<U>(key, methodDescriptions, visibility);
                            }

                            @Override
                            public Entry<U> inject(Harmonized<U> key, Visibility visibility) {
                                return new Ambiguous<U>(this.key.combineWith(key), this.methodDescriptions, this.visibility.expandTo(visibility));
                            }

                            @Override
                            public net.bytebuddy.dynamic.scaffold.MethodGraph$Node asNode(Merger merger) {
                                Iterator iterator = this.methodDescriptions.iterator();
                                MethodDescription methodDescription = (MethodDescription)iterator.next();
                                while (iterator.hasNext()) {
                                    methodDescription = merger.merge(methodDescription, (MethodDescription)iterator.next());
                                }
                                return new Node(this.key.detach(methodDescription.asTypeToken()), methodDescription, this.visibility);
                            }

                            public boolean equals(Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (other == null || this.getClass() != other.getClass()) {
                                    return false;
                                }
                                Ambiguous ambiguous = (Ambiguous)other;
                                return this.key.equals(ambiguous.key) && this.methodDescriptions.equals(ambiguous.methodDescriptions) && this.visibility.equals(ambiguous.visibility);
                            }

                            public int hashCode() {
                                int result = this.key.hashCode();
                                result = 31 * result + this.methodDescriptions.hashCode();
                                result = 31 * result + this.visibility.hashCode();
                                return result;
                            }

                            public String toString() {
                                return "MethodGraph.Compiler.Default.Key.Store.Entry.Ambiguous{key=" + this.key + ", methodDescriptions=" + this.methodDescriptions + ", visibility=" + this.visibility + '}';
                            }

                            protected static class Node
                            implements net.bytebuddy.dynamic.scaffold.MethodGraph$Node {
                                private final Detached key;
                                private final MethodDescription methodDescription;
                                private final Visibility visibility;

                                protected Node(Detached key, MethodDescription methodDescription, Visibility visibility) {
                                    this.key = key;
                                    this.methodDescription = methodDescription;
                                    this.visibility = visibility;
                                }

                                @Override
                                public Node.Sort getSort() {
                                    return Node.Sort.AMBIGUOUS;
                                }

                                @Override
                                public MethodDescription getRepresentative() {
                                    return this.methodDescription;
                                }

                                @Override
                                public Set<MethodDescription.TypeToken> getMethodTypes() {
                                    return this.key.getIdentifiers();
                                }

                                @Override
                                public Visibility getVisibility() {
                                    return this.visibility;
                                }

                                public boolean equals(Object other) {
                                    if (this == other) {
                                        return true;
                                    }
                                    if (other == null || this.getClass() != other.getClass()) {
                                        return false;
                                    }
                                    Node node = (Node)other;
                                    return this.key.equals(node.key) && this.visibility.equals(node.visibility) && this.methodDescription.equals(node.methodDescription);
                                }

                                public int hashCode() {
                                    int result = this.key.hashCode();
                                    result = 31 * result + this.methodDescription.hashCode();
                                    result = 31 * result + this.visibility.hashCode();
                                    return result;
                                }

                                public String toString() {
                                    return "MethodGraph.Compiler.Default.Key.Store.Entry.Ambiguous.Node{key=" + this.key + ", visibility=" + this.visibility + ", methodDescription=" + this.methodDescription + '}';
                                }
                            }
                        }

                        public static class Resolved<U>
                        implements Entry<U> {
                            private static final int MADE_VISIBLE = 5;
                            private static final boolean NOT_MADE_VISIBLE = false;
                            private final Harmonized<U> key;
                            private final MethodDescription methodDescription;
                            private final Visibility visibility;
                            private final boolean madeVisible;

                            protected Resolved(Harmonized<U> key, MethodDescription methodDescription, Visibility visibility, boolean madeVisible) {
                                this.key = key;
                                this.methodDescription = methodDescription;
                                this.visibility = visibility;
                                this.madeVisible = madeVisible;
                            }

                            private static <V> Entry<V> of(Harmonized<V> key, MethodDescription override, MethodDescription original, Visibility visibility) {
                                visibility = visibility.expandTo(original.getVisibility()).expandTo(override.getVisibility());
                                return override.isBridge() ? new Resolved<V>(key, original, visibility, (original.getDeclaringType().getModifiers() & 5) == 0) : new Resolved<V>(key, override, visibility, false);
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                return this.key;
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                return Collections.singleton(this.methodDescription);
                            }

                            @Override
                            public Visibility getVisibility() {
                                return this.visibility;
                            }

                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                Harmonized<U> key = this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), harmonizer);
                                Visibility visibility = this.visibility.expandTo(methodDescription.getVisibility());
                                return methodDescription.getDeclaringType().equals(this.methodDescription.getDeclaringType()) ? Ambiguous.of(key, methodDescription, this.methodDescription, visibility) : Resolved.of(key, methodDescription, this.methodDescription, visibility);
                            }

                            @Override
                            public Entry<U> inject(Harmonized<U> key, Visibility visibility) {
                                return new Resolved<U>(this.key.combineWith(key), this.methodDescription, this.visibility.expandTo(visibility), this.madeVisible);
                            }

                            @Override
                            public net.bytebuddy.dynamic.scaffold.MethodGraph$Node asNode(Merger merger) {
                                return new Node(this.key.detach(this.methodDescription.asTypeToken()), this.methodDescription, this.visibility, this.madeVisible);
                            }

                            public boolean equals(Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (other == null || this.getClass() != other.getClass()) {
                                    return false;
                                }
                                Resolved resolved = (Resolved)other;
                                return this.madeVisible == resolved.madeVisible && this.key.equals(resolved.key) && this.methodDescription.equals(resolved.methodDescription) && this.visibility.equals(resolved.visibility);
                            }

                            public int hashCode() {
                                int result = this.key.hashCode();
                                result = 31 * result + this.methodDescription.hashCode();
                                result = 31 * result + this.visibility.hashCode();
                                result = 31 * result + (this.madeVisible ? 1 : 0);
                                return result;
                            }

                            public String toString() {
                                return "MethodGraph.Compiler.Default.Key.Store.Entry.Resolved{key=" + this.key + ", methodDescription=" + this.methodDescription + ", visibility=" + this.visibility + ", madeVisible=" + this.madeVisible + '}';
                            }

                            protected static class Node
                            implements net.bytebuddy.dynamic.scaffold.MethodGraph$Node {
                                private final Detached key;
                                private final MethodDescription methodDescription;
                                private final Visibility visibility;
                                private final boolean visible;

                                protected Node(Detached key, MethodDescription methodDescription, Visibility visibility, boolean visible) {
                                    this.key = key;
                                    this.methodDescription = methodDescription;
                                    this.visibility = visibility;
                                    this.visible = visible;
                                }

                                @Override
                                public Node.Sort getSort() {
                                    return this.visible ? Node.Sort.VISIBLE : Node.Sort.RESOLVED;
                                }

                                @Override
                                public MethodDescription getRepresentative() {
                                    return this.methodDescription;
                                }

                                @Override
                                public Set<MethodDescription.TypeToken> getMethodTypes() {
                                    return this.key.getIdentifiers();
                                }

                                @Override
                                public Visibility getVisibility() {
                                    return this.visibility;
                                }

                                public boolean equals(Object other) {
                                    if (this == other) {
                                        return true;
                                    }
                                    if (other == null || this.getClass() != other.getClass()) {
                                        return false;
                                    }
                                    Node node = (Node)other;
                                    return this.visible == node.visible && this.key.equals(node.key) && this.visibility.equals(node.visibility) && this.methodDescription.equals(node.methodDescription);
                                }

                                public int hashCode() {
                                    int result = this.key.hashCode();
                                    result = 31 * result + this.methodDescription.hashCode();
                                    result = 31 * result + this.visibility.hashCode();
                                    result = 31 * result + (this.visible ? 1 : 0);
                                    return result;
                                }

                                public String toString() {
                                    return "MethodGraph.Compiler.Default.Key.Store.Entry.Resolved.Node{key=" + this.key + ", methodDescription=" + this.methodDescription + ", visibility=" + this.visibility + ", visible=" + this.visible + '}';
                                }
                            }
                        }

                        public static class Initial<U>
                        implements Entry<U> {
                            private final Harmonized<U> key;

                            protected Initial(Harmonized<U> key) {
                                this.key = key;
                            }

                            @Override
                            public Harmonized<U> getKey() {
                                throw new IllegalStateException("Cannot extract key from initial entry:" + this);
                            }

                            @Override
                            public Set<MethodDescription> getCandidates() {
                                throw new IllegalStateException("Cannot extract method from initial entry:" + this);
                            }

                            @Override
                            public Visibility getVisibility() {
                                throw new IllegalStateException("Cannot extract visibility from initial entry:" + this);
                            }

                            @Override
                            public Entry<U> extendBy(MethodDescription methodDescription, Harmonizer<U> harmonizer) {
                                return new Resolved<U>(this.key.extend((MethodDescription.InDefinedShape)methodDescription.asDefined(), harmonizer), methodDescription, methodDescription.getVisibility(), false);
                            }

                            @Override
                            public Entry<U> inject(Harmonized<U> key, Visibility visibility) {
                                throw new IllegalStateException("Cannot inject into initial entry without a registered method: " + this);
                            }

                            @Override
                            public Node asNode(Merger merger) {
                                throw new IllegalStateException("Cannot transform initial entry without a registered method: " + this);
                            }

                            public boolean equals(Object other) {
                                return this == other || other != null && this.getClass() == other.getClass() && this.key.equals(((Initial)other).key);
                            }

                            public int hashCode() {
                                return this.key.hashCode();
                            }

                            public String toString() {
                                return "MethodGraph.Compiler.Default.Key.Store.Entry.Initial{key=" + this.key + '}';
                            }
                        }
                    }
                }

                protected static class Detached
                extends Key<MethodDescription.TypeToken> {
                    private final Set<MethodDescription.TypeToken> identifiers;

                    protected Detached(String internalName, Set<MethodDescription.TypeToken> identifiers) {
                        super(internalName);
                        this.identifiers = identifiers;
                    }

                    protected static Detached of(MethodDescription.SignatureToken token) {
                        return new Detached(token.getName(), Collections.singleton(token.asTypeToken()));
                    }

                    @Override
                    protected Set<MethodDescription.TypeToken> getIdentifiers() {
                        return this.identifiers;
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Key.Detached{internalName='" + this.internalName + '\'' + ", identifiers=" + this.identifiers + '}';
                    }
                }

                protected static class Harmonized<V>
                extends Key<V> {
                    private final Map<V, Set<MethodDescription.TypeToken>> identifiers;

                    protected Harmonized(String internalName, Map<V, Set<MethodDescription.TypeToken>> identifiers) {
                        super(internalName);
                        this.identifiers = identifiers;
                    }

                    protected static <Q> Harmonized<Q> of(MethodDescription methodDescription, Harmonizer<Q> harmonizer) {
                        MethodDescription.TypeToken typeToken = methodDescription.asTypeToken();
                        return new Harmonized<Q>(methodDescription.getInternalName(), Collections.singletonMap(harmonizer.harmonize(typeToken), Collections.emptySet()));
                    }

                    protected Detached detach(MethodDescription.TypeToken typeToken) {
                        HashSet<MethodDescription.TypeToken> identifiers = new HashSet<MethodDescription.TypeToken>();
                        for (Set<MethodDescription.TypeToken> typeTokens : this.identifiers.values()) {
                            identifiers.addAll(typeTokens);
                        }
                        identifiers.add(typeToken);
                        return new Detached(this.internalName, identifiers);
                    }

                    protected Harmonized<V> combineWith(Harmonized<V> key) {
                        HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>> identifiers = new HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>>(this.identifiers);
                        for (Map.Entry<V, Set<MethodDescription.TypeToken>> entry : key.identifiers.entrySet()) {
                            HashSet typeTokens = (HashSet)identifiers.get(entry.getKey());
                            if (typeTokens == null) {
                                identifiers.put((Set<MethodDescription.TypeToken>)entry.getKey(), entry.getValue());
                                continue;
                            }
                            typeTokens = new HashSet(typeTokens);
                            typeTokens.addAll(entry.getValue());
                            identifiers.put((Set<MethodDescription.TypeToken>)entry.getKey(), typeTokens);
                        }
                        return new Harmonized<V>(this.internalName, identifiers);
                    }

                    protected Harmonized<V> extend(MethodDescription.InDefinedShape methodDescription, Harmonizer<V> harmonizer) {
                        HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>> identifiers = new HashMap<Set<MethodDescription.TypeToken>, Set<MethodDescription.TypeToken>>(this.identifiers);
                        MethodDescription.TypeToken typeToken = methodDescription.asTypeToken();
                        V identifier = harmonizer.harmonize(typeToken);
                        HashSet<MethodDescription.TypeToken> typeTokens = (HashSet<MethodDescription.TypeToken>)identifiers.get(identifier);
                        if (typeTokens == null) {
                            identifiers.put((Set<MethodDescription.TypeToken>)identifier, Collections.singleton(typeToken));
                        } else {
                            typeTokens = new HashSet<MethodDescription.TypeToken>(typeTokens);
                            typeTokens.add(typeToken);
                            identifiers.put((Set<MethodDescription.TypeToken>)identifier, (Set<MethodDescription.TypeToken>)typeTokens);
                        }
                        return new Harmonized<V>(this.internalName, identifiers);
                    }

                    @Override
                    protected Set<V> getIdentifiers() {
                        return this.identifiers.keySet();
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Key.Harmonized{internalName='" + this.internalName + '\'' + ", identifiers=" + this.identifiers + '}';
                    }
                }
            }

            public static interface Merger {
                public MethodDescription merge(MethodDescription var1, MethodDescription var2);

                public static enum Directional implements Merger
                {
                    LEFT(true),
                    RIGHT(false);

                    private final boolean left;

                    private Directional(boolean left) {
                        this.left = left;
                    }

                    @Override
                    public MethodDescription merge(MethodDescription left, MethodDescription right) {
                        return this.left ? left : right;
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Merger.Directional." + this.name();
                    }
                }
            }

            public static interface Harmonizer<S> {
                public S harmonize(MethodDescription.TypeToken var1);

                public static enum ForJVMMethod implements Harmonizer<Token>
                {
                    INSTANCE;


                    @Override
                    public Token harmonize(MethodDescription.TypeToken typeToken) {
                        return new Token(typeToken);
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Harmonizer.ForJVMMethod." + this.name();
                    }

                    protected static class Token {
                        private final MethodDescription.TypeToken typeToken;

                        public Token(MethodDescription.TypeToken typeToken) {
                            this.typeToken = typeToken;
                        }

                        public boolean equals(Object other) {
                            return this == other || other instanceof Token && this.typeToken.getReturnType().equals(((Token)other).typeToken.getReturnType()) && this.typeToken.getParameterTypes().equals(((Token)other).typeToken.getParameterTypes());
                        }

                        public int hashCode() {
                            return this.typeToken.getReturnType().hashCode() + 31 * this.typeToken.getParameterTypes().hashCode();
                        }

                        public String toString() {
                            return "MethodGraph.Compiler.Default.Harmonizer.ForJVMMethod.Token{typeToken=" + this.typeToken + '}';
                        }
                    }
                }

                public static enum ForJavaMethod implements Harmonizer<Token>
                {
                    INSTANCE;


                    @Override
                    public Token harmonize(MethodDescription.TypeToken typeToken) {
                        return new Token(typeToken);
                    }

                    public String toString() {
                        return "MethodGraph.Compiler.Default.Harmonizer.ForJavaMethod." + this.name();
                    }

                    protected static class Token {
                        private final MethodDescription.TypeToken typeToken;

                        protected Token(MethodDescription.TypeToken typeToken) {
                            this.typeToken = typeToken;
                        }

                        public boolean equals(Object other) {
                            return this == other || other instanceof Token && this.typeToken.getParameterTypes().equals(((Token)other).typeToken.getParameterTypes());
                        }

                        public int hashCode() {
                            return this.typeToken.getParameterTypes().hashCode();
                        }

                        public String toString() {
                            return "MethodGraph.Compiler.Default.Harmonizer.ForJavaMethod.Token{typeToken=" + this.typeToken + '}';
                        }
                    }
                }
            }
        }

        public static abstract class AbstractBase
        implements Compiler {
            @Override
            public Linked compile(TypeDescription typeDescription) {
                return this.compile(typeDescription, typeDescription);
            }
        }
    }

    public static interface Node {
        public Sort getSort();

        public MethodDescription getRepresentative();

        public Set<MethodDescription.TypeToken> getMethodTypes();

        public Visibility getVisibility();

        public static class Simple
        implements Node {
            private final MethodDescription methodDescription;

            public Simple(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public Sort getSort() {
                return Sort.RESOLVED;
            }

            @Override
            public MethodDescription getRepresentative() {
                return this.methodDescription;
            }

            @Override
            public Set<MethodDescription.TypeToken> getMethodTypes() {
                return Collections.emptySet();
            }

            @Override
            public Visibility getVisibility() {
                return this.methodDescription.getVisibility();
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((Simple)other).methodDescription);
            }

            public int hashCode() {
                return this.methodDescription.hashCode();
            }

            public String toString() {
                return "MethodGraph.Node.Simple{methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum Unresolved implements Node
        {
            INSTANCE;


            @Override
            public Sort getSort() {
                return Sort.UNRESOLVED;
            }

            @Override
            public MethodDescription getRepresentative() {
                throw new IllegalStateException("Cannot resolve the method of an illegal node");
            }

            @Override
            public Set<MethodDescription.TypeToken> getMethodTypes() {
                throw new IllegalStateException("Cannot resolve bridge method of an illegal node");
            }

            @Override
            public Visibility getVisibility() {
                throw new IllegalStateException("Cannot resolve visibility of an illegal node");
            }

            public String toString() {
                return "MethodGraph.Node.Unresolved." + this.name();
            }
        }

        public static enum Sort {
            VISIBLE(true, true, true),
            RESOLVED(true, true, false),
            AMBIGUOUS(true, false, false),
            UNRESOLVED(false, false, false);

            private final boolean resolved;
            private final boolean unique;
            private final boolean madeVisible;

            private Sort(boolean resolved, boolean unique, boolean madeVisible) {
                this.resolved = resolved;
                this.unique = unique;
                this.madeVisible = madeVisible;
            }

            public boolean isResolved() {
                return this.resolved;
            }

            public boolean isUnique() {
                return this.unique;
            }

            public boolean isMadeVisible() {
                return this.madeVisible;
            }

            public String toString() {
                return "MethodGraph.Node.Sort." + this.name();
            }
        }
    }

    public static interface Linked
    extends MethodGraph {
        public MethodGraph getSuperClassGraph();

        public MethodGraph getInterfaceGraph(TypeDescription var1);

        public static class Delegation
        implements Linked {
            private final MethodGraph methodGraph;
            private final MethodGraph superClassGraph;
            private final Map<TypeDescription, MethodGraph> interfaceGraphs;

            public Delegation(MethodGraph methodGraph, MethodGraph superClassGraph, Map<TypeDescription, MethodGraph> interfaceGraphs) {
                this.methodGraph = methodGraph;
                this.superClassGraph = superClassGraph;
                this.interfaceGraphs = interfaceGraphs;
            }

            @Override
            public MethodGraph getSuperClassGraph() {
                return this.superClassGraph;
            }

            @Override
            public MethodGraph getInterfaceGraph(TypeDescription typeDescription) {
                MethodGraph interfaceGraph = this.interfaceGraphs.get(typeDescription);
                return interfaceGraph == null ? Empty.INSTANCE : interfaceGraph;
            }

            @Override
            public Node locate(MethodDescription.SignatureToken token) {
                return this.methodGraph.locate(token);
            }

            @Override
            public NodeList listNodes() {
                return this.methodGraph.listNodes();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Delegation that = (Delegation)other;
                return this.methodGraph.equals(that.methodGraph) && this.superClassGraph.equals(that.superClassGraph) && this.interfaceGraphs.equals(that.interfaceGraphs);
            }

            public int hashCode() {
                int result = this.methodGraph.hashCode();
                result = 31 * result + this.superClassGraph.hashCode();
                result = 31 * result + this.interfaceGraphs.hashCode();
                return result;
            }

            public String toString() {
                return "MethodGraph.Linked.Delegation{methodGraph=" + this.methodGraph + ", superClassGraph=" + this.superClassGraph + ", interfaceGraphs=" + this.interfaceGraphs + '}';
            }
        }
    }

    public static enum Empty implements Linked,
    Compiler
    {
        INSTANCE;


        @Override
        public Node locate(MethodDescription.SignatureToken token) {
            return Node.Unresolved.INSTANCE;
        }

        @Override
        public NodeList listNodes() {
            return new NodeList(Collections.emptyList());
        }

        @Override
        public MethodGraph getSuperClassGraph() {
            return this;
        }

        @Override
        public MethodGraph getInterfaceGraph(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public Linked compile(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public Linked compile(TypeDefinition typeDefinition, TypeDescription viewPoint) {
            return this;
        }

        public String toString() {
            return "MethodGraph.Empty." + this.name();
        }
    }
}

