/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum GraalImageCode {
    AGENT(true, false),
    BUILD(true, false),
    RUNTIME(true, true),
    UNKNOWN(false, false),
    NONE(false, false);

    @MaybeNull
    private static GraalImageCode current;
    private final boolean defined;
    private final boolean nativeImageExecution;

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="This behaviour is intended to avoid early binding in native images.")
    public static GraalImageCode getCurrent() {
        GraalImageCode current = GraalImageCode.current;
        if (current == null) {
            String vendor;
            String value = GraalImageCode.doPrivileged(new GetSystemPropertyAction("org.graalvm.nativeimage.imagecode"));
            current = value == null ? ((vendor = GraalImageCode.doPrivileged(new GetSystemPropertyAction("java.vm.vendor"))) != null && vendor.toLowerCase(Locale.US).contains("graalvm") ? GraalImageCode.doPrivileged(ImageCodeContextAction.INSTANCE) : NONE) : (value.equalsIgnoreCase("agent") ? AGENT : (value.equalsIgnoreCase("runtime") ? RUNTIME : (value.equalsIgnoreCase("buildtime") ? BUILD : UNKNOWN)));
            GraalImageCode.current = current;
        }
        return current;
    }

    public <T> T[] sorted(T[] value, Comparator<? super T> comparator) {
        if (this.defined) {
            Arrays.sort(value, comparator);
        }
        return value;
    }

    @MaybeNull
    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    private GraalImageCode(boolean defined, boolean nativeImageExecution) {
        this.defined = defined;
        this.nativeImageExecution = nativeImageExecution;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isNativeImageExecution() {
        return this.nativeImageExecution;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static enum ImageCodeContextAction implements PrivilegedAction<GraalImageCode>
    {
        INSTANCE;


        @Override
        public GraalImageCode run() {
            try {
                Method method = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", new Class[0]);
                List arguments = (List)method.getReturnType().getMethod("getInputArguments", new Class[0]).invoke(method.invoke(null, new Object[0]), new Object[0]);
                for (String argument : arguments) {
                    if (!argument.startsWith("-agentlib:native-image-agent")) continue;
                    return AGENT;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return NONE;
        }
    }
}

