/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2;

import com.box.boxjavalibv2.BoxConnectionManagerBuilder;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.IBoxRequest;
import com.box.restclientv2.responses.DefaultBoxResponse;
import com.box.restclientv2.responses.IBoxResponse;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class BoxBasicRestClient
implements IBoxRESTClient {
    private final DefaultHttpClient mHttpClient;

    public HttpClient getRawHttpClient() {
        return this.mHttpClient;
    }

    public BoxBasicRestClient(BoxConnectionManagerBuilder.BoxConnectionManager connectionManager) {
        this.mHttpClient = connectionManager.getMonitoredRestClient();
    }

    public BoxBasicRestClient() {
        this.mHttpClient = new DefaultHttpClient();
    }

    public IBoxResponse execute(IBoxRequest boxRequest) throws BoxRestException, AuthFatalFailureException {
        HttpResponse response;
        HttpUriRequest httpRequest = boxRequest.prepareRequest();
        try {
            response = this.getRawHttpClient().execute(httpRequest);
        }
        catch (IOException e) {
            throw new BoxRestException(e);
        }
        DefaultBoxResponse boxResponse = new DefaultBoxResponse(response);
        boxResponse.setExpectedResponseCode(boxRequest.getExpectedResponseCode());
        return boxResponse;
    }
}

