/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.httpentities;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.jsonentities.IBoxJSONStringEntity;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartEntityWithProgressListener
extends MultipartEntity {
    public static final int ON_PROGRESS_UPDATE_THRESHOLD = 300;
    private static int onProgressUpdateThreshold = 300;
    private IFileTransferListener mListener;
    private CountingOutputStream mCountingOutputStream;
    private final HashMap<String, ContentBody> parts = new HashMap();
    private final HashMap<String, IBoxJSONStringEntity> stringParts = new HashMap();

    public MultipartEntityWithProgressListener(HttpMultipartMode mode) {
        super(mode, null, Charset.forName("UTF-8"));
    }

    public void addContentBodyPart(String name, ContentBody contentBody) {
        this.parts.put(name, contentBody);
    }

    public ContentBody getContentBodyPart(String name) {
        return this.parts.get(name);
    }

    public void addBoxJSONStringEntityPart(String name, IBoxJSONStringEntity entity) {
        this.stringParts.put(name, entity);
    }

    public IBoxJSONStringEntity getJSONStringEntityPart(String name) {
        return this.stringParts.get(name);
    }

    public void prepareParts(IBoxJSONParser parser) throws UnsupportedEncodingException, BoxJSONException {
        for (Map.Entry<String, ContentBody> entry : this.parts.entrySet()) {
            super.addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.stringParts.entrySet()) {
            super.addPart(entry.getKey(), (ContentBody)new StringBody(((IBoxJSONStringEntity)entry.getValue()).toJSONString(parser), Charset.forName("UTF-8")));
        }
    }

    public void setListener(IFileTransferListener listener) {
        this.mListener = listener;
    }

    public static void setOnProgressUpdateThreshold(int threshold) {
        onProgressUpdateThreshold = threshold;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (this.mCountingOutputStream == null) {
            this.mCountingOutputStream = new CountingOutputStream(outstream, this.mListener);
        }
        super.writeTo((OutputStream)this.mCountingOutputStream);
        if (this.mListener != null) {
            this.mListener.onProgress(this.mCountingOutputStream.getBytesTransferred());
        }
    }

    public static class InterruptedMultipartException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        private final IFileTransferListener mProgresslistener;
        private long bytesBransferred;
        private long lastOnProgressPost = 0L;

        public CountingOutputStream(OutputStream out, IFileTransferListener progressListener) {
            super(out);
            this.mProgresslistener = progressListener;
            this.bytesBransferred = 0L;
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            block4: {
                try {
                    this.out.write(buffer, offset, length);
                }
                catch (IOException e) {
                    if (this.mProgresslistener == null) break block4;
                    this.mProgresslistener.onIOException(e);
                }
            }
            this.bytesBransferred += (long)length;
            long currTime = System.currentTimeMillis();
            if (this.mProgresslistener != null && currTime - this.lastOnProgressPost > (long)onProgressUpdateThreshold) {
                this.lastOnProgressPost = currTime;
                this.mProgresslistener.onProgress(this.bytesBransferred);
            }
            if (Thread.currentThread().isInterrupted() && this.mProgresslistener != null) {
                this.mProgresslistener.onCanceled();
                throw new InterruptedMultipartException();
            }
        }

        public long getBytesTransferred() {
            return this.bytesBransferred;
        }
    }
}

