/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.requestsbase;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.httpentities.MultipartEntityWithProgressListener;
import com.box.boxjavalibv2.jsonentities.IBoxJSONStringEntity;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.utils.ISO8601DateParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

public class BoxFileUploadRequestObject
extends BoxDefaultRequestObject {
    private static final String METADATA = "metadata";
    private MultipartEntityWithProgressListener entity = null;
    private static final String PLACEHOLDER_FILENAME = "placeholder.txt";
    private static final String KEY_PARENT = "parent";
    private static final String KEY_NAME = "name";
    private static final String KEY_FILE_NAME = "filename";
    private static final String KEY_CONTENT_CREATED_AT = "content_created_at";
    private static final String KEY_CONTENT_MODIFIED_AT = "content_modified_at";

    private BoxFileUploadRequestObject() {
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, File file) throws BoxRestException, BoxJSONException {
        try {
            BoxFileUploadRequestObject requestObject = new BoxFileUploadRequestObject();
            return requestObject.setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, fileName, file));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, File file, Date createdAt, Date modifiedAt) throws BoxRestException, BoxJSONException {
        try {
            BoxFileUploadRequestObject requestObject = new BoxFileUploadRequestObject();
            return requestObject.setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, fileName, file, createdAt, modifiedAt));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadFileRequestObject(String parentId, String fileName, InputStream inputStream) throws BoxRestException, BoxJSONException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, inputStream, fileName));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, File file) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, file));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, File file, Date modifiedAt) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, file, modifiedAt));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public static BoxFileUploadRequestObject uploadNewVersionRequestObject(String name, InputStream inputStream) throws BoxRestException {
        try {
            return new BoxFileUploadRequestObject().setMultipartMIME(BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, inputStream));
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    public BoxFileUploadRequestObject setMultipartMIME(MultipartEntityWithProgressListener mime) throws BoxRestException {
        this.entity = mime;
        return this;
    }

    public BoxFileUploadRequestObject setListener(IFileTransferListener listener) {
        this.entity.setListener(listener);
        return this;
    }

    public BoxFileUploadRequestObject setContentMD5(String sha1) {
        this.getRequestExtras().addHeader("Content-MD5", sha1);
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileCreatedAt(Date createdAt) throws UnsupportedEncodingException {
        this.entity.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getCreatedAtMetadataBody(createdAt));
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileLastModifiedAt(Date modifiedAt) throws UnsupportedEncodingException {
        this.entity.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getModifiedAtMetadataBody(modifiedAt));
        return this;
    }

    public BoxFileUploadRequestObject setLocalFileCreatedAndModifiedAt(Date createdAt, Date modifiedAt) throws UnsupportedEncodingException {
        this.entity.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getCreatedAndModifiedAtMetadataBody(createdAt, modifiedAt));
        return this;
    }

    @Override
    public HttpEntity getEntity(IBoxJSONParser parser) throws UnsupportedEncodingException, BoxJSONException {
        this.entity.prepareParts(parser);
        return this.entity;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, InputStream inputStream, String fileName) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart("parent_id", (ContentBody)new StringBody(parentId));
        me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getBasicMetadataBody(parentId, fileName));
        me.addContentBodyPart(KEY_FILE_NAME, (ContentBody)new InputStreamBody(inputStream, PLACEHOLDER_FILENAME));
        return me;
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, String name, File file) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        return BoxFileUploadRequestObject.getNewFileMultipartEntity(parentId, name, file, null, new Date(file.lastModified()));
    }

    private static MultipartEntityWithProgressListener getNewFileMultipartEntity(String parentId, String name, File file, Date createdAt, Date modifiedAt) throws BoxRestException, UnsupportedEncodingException, BoxJSONException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart("parent_id", (ContentBody)new StringBody(parentId));
        if (modifiedAt == null) {
            modifiedAt = new Date(file.lastModified());
        }
        if (createdAt == null) {
            me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getBasicMetadataBodyWithModifiedAt(parentId, name, modifiedAt));
        } else {
            me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getBasicMetadataBodyWithCreatedAndModifiedAt(parentId, name, createdAt, modifiedAt));
        }
        me.addContentBodyPart(KEY_FILE_NAME, (ContentBody)new FileBody(file, PLACEHOLDER_FILENAME, "*/*", "UTF-8"));
        return me;
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, File file) throws UnsupportedEncodingException {
        return BoxFileUploadRequestObject.getNewVersionMultipartEntity(name, file, null);
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, File file, Date modifiedAt) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart(KEY_FILE_NAME, (ContentBody)new FileBody(file, PLACEHOLDER_FILENAME, "*/*", "UTF-8"));
        if (modifiedAt == null) {
            modifiedAt = new Date(file.lastModified());
        }
        me.addBoxJSONStringEntityPart(METADATA, BoxFileUploadRequestObject.getModifiedAtMetadataBody(modifiedAt));
        return me;
    }

    private static MultipartEntityWithProgressListener getNewVersionMultipartEntity(String name, InputStream inputStream) throws UnsupportedEncodingException {
        MultipartEntityWithProgressListener me = new MultipartEntityWithProgressListener(HttpMultipartMode.BROWSER_COMPATIBLE);
        me.addContentBodyPart(KEY_FILE_NAME, (ContentBody)new InputStreamBody(inputStream, PLACEHOLDER_FILENAME));
        return me;
    }

    private static IBoxJSONStringEntity getBasicMetadataBody(String parentId, String name) throws UnsupportedEncodingException, BoxRestException, BoxJSONException {
        MapJSONStringEntity parentEntity = new MapJSONStringEntity();
        parentEntity.put("id", parentId);
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_PARENT, parentEntity);
        entity.put(KEY_NAME, name);
        return entity;
    }

    private static IBoxJSONStringEntity getBasicMetadataBodyWithModifiedAt(String parentId, String name, Date modifiedAt) throws UnsupportedEncodingException, BoxRestException, BoxJSONException {
        MapJSONStringEntity entity = (MapJSONStringEntity)BoxFileUploadRequestObject.getBasicMetadataBody(parentId, name);
        entity.put(KEY_CONTENT_MODIFIED_AT, ISO8601DateParser.toString(modifiedAt));
        return entity;
    }

    private static IBoxJSONStringEntity getBasicMetadataBodyWithCreatedAndModifiedAt(String parentId, String name, Date createdAt, Date modifiedAt) throws UnsupportedEncodingException, BoxRestException, BoxJSONException {
        MapJSONStringEntity entity = (MapJSONStringEntity)BoxFileUploadRequestObject.getBasicMetadataBody(parentId, name);
        entity.put(KEY_CONTENT_CREATED_AT, ISO8601DateParser.toString(createdAt));
        entity.put(KEY_CONTENT_MODIFIED_AT, ISO8601DateParser.toString(modifiedAt));
        return entity;
    }

    private static IBoxJSONStringEntity getCreatedAtMetadataBody(Date createdAt) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_CONTENT_CREATED_AT, ISO8601DateParser.toString(createdAt));
        return entity;
    }

    private static IBoxJSONStringEntity getModifiedAtMetadataBody(Date modifiedAt) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_CONTENT_MODIFIED_AT, ISO8601DateParser.toString(modifiedAt));
        return entity;
    }

    private static IBoxJSONStringEntity getCreatedAndModifiedAtMetadataBody(Date createdAt, Date modifiedAt) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put(KEY_CONTENT_CREATED_AT, ISO8601DateParser.toString(createdAt));
        entity.put(KEY_CONTENT_MODIFIED_AT, ISO8601DateParser.toString(modifiedAt));
        return entity;
    }
}

