/*
 * Decompiled with CFR 0.152.
 */
package com.box.dependencywheel;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DependencyMapBuilder {
    private Map<String, Integer> classPosMap = new HashMap<String, Integer>();
    private String[] classNames;
    private int[][] matrix;
    private Map<String, Integer> pkgPosMap = new HashMap<String, Integer>();
    private String[] pkgNames;
    private int[][] pkgMatrix;

    public static void main(String[] args) throws IOException {
        DependencyMapBuilder builder = new DependencyMapBuilder();
        builder.build();
    }

    public void build() throws IOException {
        File root = new File("/Users/jlin/android-app/v2sdk/java/external/BoxJavaLibraryV2/src/com/box/boxjavalibv2");
        this.classPosMap.put("main.main", 0);
        int classCount = this.initClasses(root, 1);
        int count = classCount + 1;
        this.classNames = new String[count];
        for (Map.Entry<String, Integer> entry : this.classPosMap.entrySet()) {
            if (entry.getKey() == null) {
                int x = 0;
                ++x;
            }
            this.classNames[entry.getValue().intValue()] = entry.getKey();
        }
        this.matrix = this.initMatrix(count);
        this.handleDirectory(root);
        this.convertToPackageDependencies();
        this.createDependencyJSONString(this.pkgMatrix, this.pkgNames);
    }

    private void convertToPackageDependencies() {
        this.convertPkgNames();
        this.convertPkgMatrix();
    }

    private void convertPkgMatrix() {
        int size = this.pkgNames.length;
        this.pkgMatrix = this.initMatrix(size);
        int ni = this.matrix.length;
        int mi = this.matrix[0].length;
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < mi; ++j) {
                if (this.matrix[i][j] != 1) continue;
                String current = this.classNames[i];
                String dependency = this.classNames[j];
                String currentPkg = this.getPkgNameFromClsName(current);
                String dependencyPkg = this.getPkgNameFromClsName(dependency);
                this.pkgMatrix[this.pkgPosMap.get((Object)currentPkg).intValue()][this.pkgPosMap.get((Object)dependencyPkg).intValue()] = 1;
            }
        }
    }

    private void convertPkgNames() {
        this.pkgPosMap = new HashMap<String, Integer>();
        HashSet<String> names = new HashSet<String>();
        for (String className : this.classNames) {
            String pkgName = this.getPkgNameFromClsName(className);
            names.add(pkgName);
        }
        this.pkgNames = new String[names.size()];
        int i = 0;
        Iterator i$ = names.iterator();
        while (i$.hasNext()) {
            String n;
            this.pkgNames[i] = n = (String)i$.next();
            this.pkgPosMap.put(n, i);
            ++i;
        }
    }

    private String getPkgNameFromClsName(String clsName) {
        return clsName.substring(0, clsName.lastIndexOf(46));
    }

    private void createDependencyJSONString(int[][] matrix2, String[] classNames2) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        String namesStr = mapper.writeValueAsString((Object)classNames2).replace('\"', '\'');
        String matrixStr = this.createJSONForMatrix(matrix2);
        String result = "{packageNames:" + namesStr + ",matrix:" + matrixStr + "}";
        IOUtils.write((String)result, (OutputStream)new FileOutputStream(new File("/Users/jlin/data.txt")));
    }

    private String createJSONForMatrix(int[][] originalMatrix) throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList list = new ArrayList();
        int size = originalMatrix.length;
        for (int i = 0; i < size; ++i) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            list.add(l);
            for (int j = 0; j < size; ++j) {
                l.add(originalMatrix[i][j]);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(list);
    }

    private int initClasses(File folder, int startPos) {
        File[] children;
        int count = 0;
        int pos = startPos;
        for (File child : children = folder.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".java")) {
                ++count;
                this.classPosMap.put(this.getClassPath(child), pos);
                ++pos;
                continue;
            }
            if (!child.isDirectory()) continue;
            int initCount = count;
            pos += (count += this.initClasses(child, pos)) - initCount;
        }
        return count;
    }

    private String getClassPath(File file) {
        String path = file.getAbsolutePath();
        return path.substring(path.indexOf("com/box")).replace(".java", "").replace('/', '.');
    }

    private int[][] initMatrix(int size) {
        int[][] toInit = new int[size][size];
        for (int j = 0; j < size; ++j) {
            toInit[0][j] = 1;
        }
        toInit[0][0] = 0;
        return toInit;
    }

    private void handleFile(File file) throws IOException {
        String current = this.getClassPath(file);
        int currentPos = this.classPosMap.get(current);
        List lines = FileUtils.readLines((File)file);
        boolean started = false;
        for (String line : lines) {
            if (line.startsWith("import ")) {
                started = true;
                String dependency = line.split(" ")[1].replaceFirst(";", "");
                Integer dependencyPos = this.classPosMap.get(dependency);
                if (dependencyPos == null) continue;
                System.out.println("dependency:" + current + " on " + line);
                this.matrix[currentPos][dependencyPos.intValue()] = 1;
                continue;
            }
            if (!started) continue;
            break;
        }
    }

    private void handleDirectory(File folder) throws IOException {
        File[] children;
        for (File child : children = folder.listFiles()) {
            File[] grandChildren;
            if (child.isFile() && child.getName().endsWith(".java")) {
                this.handleFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            for (File grandChild : grandChildren = child.listFiles()) {
                if (grandChild.isFile() && grandChild.getName().endsWith(".java")) {
                    this.handleFile(grandChild);
                    continue;
                }
                if (!grandChild.isDirectory()) continue;
                this.handleDirectory(grandChild);
            }
        }
    }
}

