/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollaboration;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateNewFolderRequest;
import com.box.boxjavalibv2.requests.DeleteFolderRequest;
import com.box.boxjavalibv2.requests.GetFolderCollaborationsRequest;
import com.box.boxjavalibv2.requests.GetFolderItemsRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderDeleteRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxFolderRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemCopyRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxPagingRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxSharedLinkRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxItemsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.IBoxFoldersManager;
import com.box.boxjavalibv2.utils.Utils;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class BoxFoldersManageImpl
extends BoxItemsManagerImpl
implements IBoxFoldersManager {
    public BoxFoldersManageImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    @Override
    public BoxFolder getFolder(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.getItem(folderId, requestObject, BoxResourceType.FOLDER);
    }

    @Override
    public BoxFolder createFolder(BoxFolderRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateNewFolderRequest request = new CreateNewFolderRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxFolder)this.getResponseAndParseAndTryCast(request, BoxResourceType.FOLDER, this.getJSONParser());
    }

    @Override
    public void deleteFolder(String folderId, BoxFolderDeleteRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteFolderRequest request = new DeleteFolderRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public BoxFolder copyFolder(String folderId, BoxItemCopyRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.copyItem(folderId, requestObject, BoxResourceType.FOLDER);
    }

    @Override
    public BoxCollection getFolderItems(String folderId, BoxPagingRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderItemsRequest request = new GetFolderItemsRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.ITEMS, this.getJSONParser());
    }

    @Override
    public BoxFolder updateFolderInfo(String folderId, BoxFolderRequestObject requestObject) throws UnsupportedEncodingException, BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.updateItemInfo(folderId, requestObject, BoxResourceType.FOLDER);
    }

    @Override
    public BoxFolder createSharedLink(String folderId, BoxSharedLinkRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFolder)super.createSharedLink(folderId, requestObject, BoxResourceType.FOLDER);
    }

    @Override
    public List<BoxCollaboration> getFolderCollaborations(String folderId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFolderCollaborationsRequest request = new GetFolderCollaborationsRequest(this.getConfig(), this.getJSONParser(), folderId, requestObject);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COLLABORATIONS, this.getJSONParser());
        return Utils.getTypedObjects(collection, BoxCollaboration.class);
    }

    @Deprecated
    public static List<BoxFolder> getFolders(BoxCollection collection) {
        ArrayList<BoxFolder> folders = new ArrayList<BoxFolder>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxFolder)) continue;
            folders.add((BoxFolder)object);
        }
        return folders;
    }
}

