/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxFileVersion;
import com.box.boxjavalibv2.dao.BoxPreview;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.dao.BoxThumbnail;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedHttpStatusException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedStatus;
import com.box.boxjavalibv2.filetransfer.BoxFileDownload;
import com.box.boxjavalibv2.filetransfer.BoxFileUpload;
import com.box.boxjavalibv2.filetransfer.IFileTransferListener;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.DeleteFileRequest;
import com.box.boxjavalibv2.requests.DeleteFileVersionRequest;
import com.box.boxjavalibv2.requests.GetFileCommentsRequest;
import com.box.boxjavalibv2.requests.GetFileVersionsRequest;
import com.box.boxjavalibv2.requests.GetPreviewRequest;
import com.box.boxjavalibv2.requests.PromoteOldFileVersionRequest;
import com.box.boxjavalibv2.requests.ThumbnailRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxFileRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxImageRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxItemCopyRequestObject;
import com.box.boxjavalibv2.requests.requestobjects.BoxSharedLinkRequestObject;
import com.box.boxjavalibv2.resourcemanagers.BoxItemsManagerImpl;
import com.box.boxjavalibv2.resourcemanagers.IBoxFilesManager;
import com.box.boxjavalibv2.responseparsers.ErrorResponseParser;
import com.box.boxjavalibv2.responseparsers.PreviewResponseParser;
import com.box.boxjavalibv2.responseparsers.ThumbnailResponseParser;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import com.box.restclientv2.requestsbase.BoxFileUploadRequestObject;
import com.box.restclientv2.responseparsers.DefaultFileResponseParser;
import com.box.restclientv2.responses.DefaultBoxResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class BoxFilesManagerImpl
extends BoxItemsManagerImpl
implements IBoxFilesManager {
    public BoxFilesManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    @Override
    public BoxFile getFile(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFile)super.getItem(fileId, requestObject, BoxResourceType.FILE);
    }

    @Override
    public void deleteFile(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteFileRequest request = new DeleteFileRequest(this.getConfig(), this.getJSONParser(), fileId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public BoxPreview getPreview(String fileId, String extension, BoxImageRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetPreviewRequest request = new GetPreviewRequest(this.getConfig(), this.getJSONParser(), fileId, extension, requestObject);
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        PreviewResponseParser parser = new PreviewResponseParser();
        ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
        Object result = response.parseResponse(parser, errorParser);
        return (BoxPreview)this.tryCastObject(BoxResourceType.PREVIEW, result);
    }

    @Override
    public BoxThumbnail getThumbnail(String fileId, String extension, BoxImageRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        ThumbnailRequest request = new ThumbnailRequest(this.getConfig(), this.getJSONParser(), fileId, extension, requestObject);
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        ThumbnailResponseParser parser = new ThumbnailResponseParser();
        ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
        Object result = response.parseResponse(parser, errorParser);
        return (BoxThumbnail)this.tryCastObject(BoxResourceType.THUMBNAIL, result);
    }

    @Override
    @Deprecated
    public InputStream downloadThumbnail(String fileId, String extension, BoxImageRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        ErrorResponseParser errorParser;
        Object o;
        ThumbnailRequest request = new ThumbnailRequest(this.getConfig(), this.getJSONParser(), fileId, extension, requestObject);
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        if (response.getResponseStatusCode() != request.getExpectedResponseCode() && (o = (errorParser = new ErrorResponseParser(this.getJSONParser())).parse(response)) instanceof BoxServerError) {
            if (o instanceof BoxUnexpectedStatus) {
                throw new BoxUnexpectedHttpStatusException((BoxUnexpectedStatus)o);
            }
            throw new BoxServerException((BoxServerError)o);
        }
        return (InputStream)new DefaultFileResponseParser().parse(response);
    }

    @Override
    public BoxFile uploadFile(BoxFileUploadRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException, InterruptedException {
        BoxFileUpload upload = new BoxFileUpload(this.getConfig());
        return upload.execute(this, requestObject);
    }

    @Override
    public BoxFile copyFile(String fileId, BoxItemCopyRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFile)super.copyItem(fileId, requestObject, BoxResourceType.FILE);
    }

    @Override
    public void downloadFile(String fileId, File destination, IFileTransferListener listener, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, IllegalStateException, IOException, InterruptedException, AuthFatalFailureException {
        BoxFileDownload download = new BoxFileDownload(this.getConfig(), this.getRestClient(), fileId);
        download.setProgressListener(listener);
        download.execute(this.getAuth(), destination, this.getJSONParser(), requestObject);
    }

    @Override
    public InputStream downloadFile(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxFileDownload download = new BoxFileDownload(this.getConfig(), this.getRestClient(), fileId);
        return download.execute(this.getAuth(), this.getJSONParser(), requestObject);
    }

    @Override
    public void downloadFile(String fileId, OutputStream[] outputStreams, IFileTransferListener listener, BoxDefaultRequestObject requestObject) throws BoxRestException, IOException, BoxServerException, InterruptedException, AuthFatalFailureException {
        BoxFileDownload download = new BoxFileDownload(this.getConfig(), this.getRestClient(), fileId);
        download.setProgressListener(listener);
        download.execute(this.getAuth(), outputStreams, this.getJSONParser(), requestObject);
    }

    @Override
    public BoxFile uploadNewVersion(String fileId, BoxFileUploadRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException, InterruptedException {
        BoxFileUpload upload = new BoxFileUpload(this.getConfig());
        return upload.execute(fileId, this, requestObject);
    }

    @Override
    public List<BoxFileVersion> getFileVersions(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFileVersionsRequest request = new GetFileVersionsRequest(this.getConfig(), this.getJSONParser(), fileId, requestObject);
        BoxCollection collection = (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.FILE_VERSIONS, this.getJSONParser());
        return BoxFilesManagerImpl.getFileVersions(collection);
    }

    @Override
    public BoxFile updateFileInfo(String fileId, BoxFileRequestObject requestObject) throws UnsupportedEncodingException, BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFile)super.updateItemInfo(fileId, requestObject, BoxResourceType.FILE);
    }

    @Override
    public BoxFile createSharedLink(String fileId, BoxSharedLinkRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        return (BoxFile)super.createSharedLink(fileId, requestObject, BoxResourceType.FILE);
    }

    @Override
    public BoxCollection getFileComments(String fileId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetFileCommentsRequest request = new GetFileCommentsRequest(this.getConfig(), this.getJSONParser(), fileId, requestObject);
        return (BoxCollection)this.getResponseAndParseAndTryCast(request, BoxResourceType.COMMENTS, this.getJSONParser());
    }

    @Deprecated
    public static List<BoxFile> getFiles(BoxCollection collection) {
        ArrayList<BoxFile> files = new ArrayList<BoxFile>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxFile)) continue;
            files.add((BoxFile)object);
        }
        return files;
    }

    @Deprecated
    public static List<BoxFileVersion> getFileVersions(BoxCollection collection) {
        ArrayList<BoxFileVersion> files = new ArrayList<BoxFileVersion>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxFileVersion)) continue;
            files.add((BoxFileVersion)object);
        }
        return files;
    }

    @Override
    public void deleteFileVersion(String fileId, String versionId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteFileVersionRequest request = new DeleteFileVersionRequest(this.getConfig(), this.getJSONParser(), fileId, versionId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Override
    public void promoteOldFileVersion(String fileId, String versionId) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        PromoteOldFileVersionRequest request = PromoteOldFileVersionRequest.getRequestObject(this.getConfig(), this.getJSONParser(), fileId, versionId);
        this.executeRequestWithNoResponseBody(request);
    }
}

