/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.IBoxConfig;
import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxComment;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import com.box.boxjavalibv2.dao.IBoxType;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import com.box.boxjavalibv2.requests.CreateCommentRequest;
import com.box.boxjavalibv2.requests.DeleteCommentRequest;
import com.box.boxjavalibv2.requests.GetCommentRequest;
import com.box.boxjavalibv2.requests.UpdateCommentRequest;
import com.box.boxjavalibv2.requests.requestobjects.BoxCommentRequestObject;
import com.box.boxjavalibv2.resourcemanagers.AbstractBoxResourceManager;
import com.box.boxjavalibv2.resourcemanagers.IBoxCommentsManager;
import com.box.restclientv2.IBoxRESTClient;
import com.box.restclientv2.authorization.IBoxRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.util.ArrayList;
import java.util.List;

public final class BoxCommentsManagerImpl
extends AbstractBoxResourceManager
implements IBoxCommentsManager {
    public BoxCommentsManagerImpl(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        super(config, resourceHub, parser, auth, restClient);
    }

    @Override
    public BoxComment addComment(BoxCommentRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        CreateCommentRequest request = new CreateCommentRequest(this.getConfig(), this.getJSONParser(), requestObject);
        return (BoxComment)this.getResponseAndParseAndTryCast(request, BoxResourceType.COMMENT, this.getJSONParser());
    }

    @Override
    public BoxComment addComment(String commentedItemId, IBoxType commentedItemType, String message) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        BoxCommentRequestObject obj = BoxCommentRequestObject.addCommentRequestObject(commentedItemType, commentedItemId, message);
        return this.addComment(obj);
    }

    @Override
    public BoxComment getComment(String commentId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        GetCommentRequest request = new GetCommentRequest(this.getConfig(), this.getJSONParser(), commentId, requestObject);
        return (BoxComment)this.getResponseAndParseAndTryCast(request, BoxResourceType.COMMENT, this.getJSONParser());
    }

    @Override
    public BoxComment updateComment(String commentId, BoxCommentRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        UpdateCommentRequest request = new UpdateCommentRequest(this.getConfig(), this.getJSONParser(), commentId, requestObject);
        return (BoxComment)this.getResponseAndParseAndTryCast(request, BoxResourceType.COMMENT, this.getJSONParser());
    }

    @Override
    public void deleteComment(String commentId, BoxDefaultRequestObject requestObject) throws BoxRestException, BoxServerException, AuthFatalFailureException {
        DeleteCommentRequest request = new DeleteCommentRequest(this.getConfig(), this.getJSONParser(), commentId, requestObject);
        this.executeRequestWithNoResponseBody(request);
    }

    @Deprecated
    public static List<BoxComment> getComments(BoxCollection collection) {
        ArrayList<BoxComment> comments = new ArrayList<BoxComment>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!(object instanceof BoxComment)) continue;
            comments.add((BoxComment)object);
        }
        return comments;
    }
}

