/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.requests.requestobjects;

import com.box.boxjavalibv2.dao.IBoxType;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BoxCommentRequestObject
extends BoxDefaultRequestObject {
    private BoxCommentRequestObject() {
    }

    public static BoxCommentRequestObject addCommentRequestObject(IBoxType type, String itemId, String message) {
        BoxCommentRequestObject obj = new BoxCommentRequestObject();
        Pattern regex = Pattern.compile("@\\[\\d+:(.*?)\\]");
        Matcher matcher = regex.matcher(message);
        if (matcher.find()) {
            return obj.setItem(type, itemId).setTaggedMessage(message);
        }
        return obj.setItem(type, itemId).setMessage(message);
    }

    public static BoxCommentRequestObject updateCommentRequestObject(String message) {
        BoxCommentRequestObject obj = new BoxCommentRequestObject();
        return obj.setMessage(message);
    }

    public BoxCommentRequestObject setMessage(String message) {
        this.put("message", message);
        return this;
    }

    public BoxCommentRequestObject setTaggedMessage(String message) {
        this.put("tagged_message", message);
        return this;
    }

    public BoxCommentRequestObject setItem(IBoxType type, String itemId) {
        this.put("item", BoxCommentRequestObject.getItemEntity(type, itemId));
        return this;
    }

    private static MapJSONStringEntity getItemEntity(IBoxType type, String itemId) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put("type", type.toString());
        entity.put("id", itemId);
        return entity;
    }
}

