/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.jsonparsing;

import com.box.boxjavalibv2.dao.BoxObject;
import com.box.boxjavalibv2.dao.IBoxType;
import com.box.boxjavalibv2.jsonparsing.IBoxResourceHub;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BaseBoxResourceHub
implements IBoxResourceHub {
    protected final Map<String, IBoxType> lowercaseStringToType = new HashMap<String, IBoxType>();

    public BaseBoxResourceHub() {
        this.initializeTypes();
    }

    public Class getClass(IBoxType type) {
        return BoxObject.class;
    }

    protected Map<String, IBoxType> getLowerCaseStringToTypeMap() {
        return this.lowercaseStringToType;
    }

    protected abstract Class getConcreteClassForIBoxType();

    protected abstract Class getObjectClassGivenConcreteIBoxType(IBoxType var1);

    protected void initializeTypes() {
    }

    protected synchronized void initializeEnumTypes(Class<? extends Enum> cls) {
        Enum[] types;
        Map<String, IBoxType> map = this.getLowerCaseStringToTypeMap();
        for (Enum type : types = cls.getEnumConstants()) {
            String str = type.name().toLowerCase(Locale.ENGLISH);
            map.put(str, (IBoxType)((Object)type));
        }
    }
}

