/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2;

import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class BoxConnectionManagerBuilder {
    private int maxConnectionPerRoute = 50;
    private int maxConnection = 1000;
    private long timePeriodCleanUpIdleConnection = 300000L;
    private long idleTimeThreshold = 60000L;

    public BoxConnectionManager build() {
        return new BoxConnectionManager(this);
    }

    public void setMaxConnectionPerRoute(int maxConnectionPerRoute) {
        this.maxConnectionPerRoute = maxConnectionPerRoute;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setTimePeriodCleanUpIdleConnection(long timePeriodCleanUpIdleConnection) {
        this.timePeriodCleanUpIdleConnection = timePeriodCleanUpIdleConnection;
    }

    public void setIdleTimeThreshold(long idleTimeThreshold) {
        this.idleTimeThreshold = idleTimeThreshold;
    }

    public class BoxConnectionManager {
        private ClientConnectionManager connectionManager;
        private final int maxConnectionPerRoute;
        private final int maxConnection;
        private final long timePeriodCleanUpIdleConnection;
        private final long idleTimeThreshold;

        private BoxConnectionManager(BoxConnectionManagerBuilder builder) {
            this.maxConnection = builder.maxConnection;
            this.maxConnectionPerRoute = builder.maxConnectionPerRoute;
            this.timePeriodCleanUpIdleConnection = builder.timePeriodCleanUpIdleConnection;
            this.idleTimeThreshold = builder.idleTimeThreshold;
            this.createConnectionManager();
        }

        public DefaultHttpClient getMonitoredRestClient() {
            return new DefaultHttpClient(this.connectionManager, this.getHttpParams());
        }

        private void createConnectionManager() {
            SchemeRegistry schemeReg = new SchemeRegistry();
            schemeReg.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeReg.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            this.connectionManager = new ThreadSafeClientConnManager(this.getHttpParams(), schemeReg);
            this.monitorConnection(this.connectionManager);
        }

        private HttpParams getHttpParams() {
            BasicHttpParams params = new BasicHttpParams();
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)this.maxConnection);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRoute(){

                public int getMaxForRoute(HttpRoute httpRoute) {
                    return BoxConnectionManager.this.maxConnectionPerRoute;
                }
            });
            return params;
        }

        private void monitorConnection(ClientConnectionManager connManager) {
            final WeakReference<ClientConnectionManager> ref = new WeakReference<ClientConnectionManager>(connManager);
            connManager = null;
            Thread monitorThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                ClientConnectionManager connMan = (ClientConnectionManager)ref.get();
                                if (connMan == null) {
                                    return;
                                }
                                this.wait(BoxConnectionManager.this.timePeriodCleanUpIdleConnection);
                                connMan.closeExpiredConnections();
                                connMan.closeIdleConnections(BoxConnectionManager.this.idleTimeThreshold, TimeUnit.SECONDS);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            monitorThread.start();
        }
    }
}

