/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FileUtils {
    public static String pathOf(File f, boolean canonical) throws Exception {
        return canonical ? f.getCanonicalPath() : f.getAbsolutePath();
    }

    public static File fileOf(File f, boolean canonical) throws Exception {
        return canonical ? f.getCanonicalFile() : f.getAbsoluteFile();
    }

    public static Set<File> fromStrings(Collection<String> s) {
        return s.stream().map(File::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static String toMultiPath(Collection<File> paths) {
        return paths.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator));
    }

    public static List<Path> listDirectoryContent(final Path directory, final Function<Path, Boolean> filter) throws IOException {
        final ArrayList<Path> paths = new ArrayList<Path>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                if (((Boolean)filter.apply(path)).booleanValue()) {
                    paths.add(path);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (!dir.equals(directory) && ((Boolean)filter.apply(dir)).booleanValue()) {
                    paths.add(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return paths;
    }

    public static void deleteDirectory(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

