/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCallerSupport;
import scala_maven_executions.MainHelper;
import scala_maven_executions.SpawnMonitor;

public class JavaMainCallerInProcess
extends JavaMainCallerSupport {
    private ClassLoader _cl;

    public JavaMainCallerInProcess(Log mavenLogger, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        super(mavenLogger, mainClassName, "", jvmArgs, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                mavenLogger.error((Throwable)e);
            }
        }
        this._cl = new URLClassLoader(urls.toArray(new URL[0]), null);
    }

    @Override
    public void addJvmArgs(String ... args0) {
        if (args0 != null) {
            for (String arg : args0) {
                this.mavenLogger.warn((CharSequence)("jvmArgs are ignored when run in process :" + arg));
            }
        }
    }

    @Override
    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        try {
            this.runInternal(displayCmd);
            return true;
        }
        catch (Exception e) {
            if (throwFailure) {
                throw e;
            }
            return false;
        }
    }

    @Override
    public SpawnMonitor spawn(boolean displayCmd) {
        Thread t = new Thread(() -> {
            try {
                this.runInternal(displayCmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
        return t::isAlive;
    }

    private void runInternal(boolean displayCmd) throws Exception {
        Object[] argArray = this.args.toArray(new String[0]);
        if (displayCmd) {
            this.mavenLogger.info((CharSequence)("cmd : " + this.mainClassName + "(" + StringUtils.join((Object[])argArray, (String)",") + ")"));
        }
        MainHelper.runMain(this.mainClassName, this.args, this._cl);
    }

    @Override
    public void redirectToLog() {
        this.mavenLogger.warn((CharSequence)"redirection to log is not supported for 'inProcess' mode");
    }
}

