/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import sbt.internal.inc.ScalaInstance;
import sbt.util.Level;
import sbt.util.Logger;
import sbt_inc.SbtIncrementalCompiler;
import sbt_inc.SbtIncrementalCompilers;
import sbt_inc.ScalaInstances;
import scala.Enumeration;
import scala.Function0;
import scala_maven_executions.ForkLogLevel;
import xsbti.compile.CompileOrder;

public final class ForkedSbtIncrementalCompilerMain {
    public static void main(String[] args) {
        final Args parsedArgs = Args.parseArgs(args);
        Logger sbtLogger = new Logger(){

            public void log(Enumeration.Value level, Function0<String> message) {
                ForkLogLevel forkLogLevel = null;
                if (level.equals((Object)Level.Error())) {
                    forkLogLevel = ForkLogLevel.ERROR;
                } else if (level.equals((Object)Level.Warn())) {
                    forkLogLevel = ForkLogLevel.WARN;
                } else if (level.equals((Object)Level.Info())) {
                    forkLogLevel = ForkLogLevel.INFO;
                } else if (level.equals((Object)Level.Debug()) && parsedArgs.debugEnabled) {
                    forkLogLevel = ForkLogLevel.DEBUG;
                }
                if (forkLogLevel != null) {
                    System.out.println(forkLogLevel.addHeader((String)message.apply()));
                }
            }

            public void success(Function0<String> message) {
                this.log(Level.Info(), message);
            }

            public void trace(Function0<Throwable> t) {
            }
        };
        ScalaInstance scalaInstance = ScalaInstances.makeScalaInstance(parsedArgs.scalaVersion, parsedArgs.compilerAndDependencies, parsedArgs.libraryAndDependencies);
        SbtIncrementalCompiler incrementalCompiler = SbtIncrementalCompilers.makeInProcess(parsedArgs.javaHome, parsedArgs.cacheFile, parsedArgs.compileOrder, scalaInstance, parsedArgs.compilerBridgeJar, sbtLogger);
        incrementalCompiler.compile(parsedArgs.classpathElements, parsedArgs.sources, parsedArgs.classesDirectory, parsedArgs.scalacOptions, parsedArgs.javacOptions);
    }

    public static final class Args {
        public final File javaHome;
        public final File cacheFile;
        public final CompileOrder compileOrder;
        public final File compilerBridgeJar;
        public final String scalaVersion;
        public final Collection<File> compilerAndDependencies;
        public final Collection<File> libraryAndDependencies;
        public final Collection<File> classpathElements;
        public final Collection<File> sources;
        public final File classesDirectory;
        public final Collection<String> scalacOptions;
        public final Collection<String> javacOptions;
        public final boolean debugEnabled;

        public Args(File javaHome, File cacheFile, CompileOrder compileOrder, File compilerBridgeJar, String scalaVersion, Collection<File> compilerAndDependencies, Collection<File> libraryAndDependencies, Collection<File> classpathElements, Collection<File> sources, File classesDirectory, Collection<String> scalacOptions, Collection<String> javacOptions, boolean debugEnabled) {
            this.javaHome = javaHome;
            this.cacheFile = cacheFile;
            this.compileOrder = compileOrder;
            this.compilerBridgeJar = compilerBridgeJar;
            this.scalaVersion = scalaVersion;
            this.compilerAndDependencies = compilerAndDependencies;
            this.libraryAndDependencies = libraryAndDependencies;
            this.classpathElements = classpathElements;
            this.sources = sources;
            this.classesDirectory = classesDirectory;
            this.scalacOptions = scalacOptions;
            this.javacOptions = javacOptions;
            this.debugEnabled = debugEnabled;
        }

        private <T> void writeCollection(List<String> args, Collection<T> collection, Function<T, String> f) {
            args.add(String.valueOf(collection.size()));
            for (T entry : collection) {
                args.add(f.apply(entry));
            }
        }

        public String[] generateArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.javaHome.toString());
            args.add(this.cacheFile.getPath());
            args.add(this.compileOrder.name());
            args.add(this.compilerBridgeJar.getPath());
            args.add(this.scalaVersion);
            this.writeCollection(args, this.compilerAndDependencies, File::getPath);
            this.writeCollection(args, this.libraryAndDependencies, File::getPath);
            this.writeCollection(args, this.classpathElements, File::getPath);
            this.writeCollection(args, this.sources, File::getPath);
            args.add(this.classesDirectory.toString());
            this.writeCollection(args, this.scalacOptions, Function.identity());
            this.writeCollection(args, this.javacOptions, Function.identity());
            args.add(String.valueOf(this.debugEnabled));
            return args.toArray(new String[0]);
        }

        private static <T> List<T> readList(String[] args, AtomicInteger index, Function<String, T> f) {
            int size = Integer.parseInt(args[index.getAndIncrement()]);
            ArrayList<T> list = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                list.add(f.apply(args[index.getAndIncrement()]));
            }
            return list;
        }

        static Args parseArgs(String[] args) {
            AtomicInteger index = new AtomicInteger();
            File javaHome = new File(args[index.getAndIncrement()]);
            File cacheFile = new File(args[index.getAndIncrement()]);
            CompileOrder compileOrder = CompileOrder.valueOf((String)args[index.getAndIncrement()]);
            File compilerBridgeJar = new File(args[index.getAndIncrement()]);
            String scalaVersion = args[index.getAndIncrement()];
            List<File> compilerAndDependencies = Args.readList(args, index, File::new);
            List<File> libraryAndDependencies = Args.readList(args, index, File::new);
            List<File> classpathElements = Args.readList(args, index, File::new);
            List<File> sources = Args.readList(args, index, File::new);
            File classesDirectory = new File(args[index.getAndIncrement()]);
            List<String> scalacOptions = Args.readList(args, index, Function.identity());
            List<String> javacOptions = Args.readList(args, index, Function.identity());
            boolean debugEnabled = Boolean.parseBoolean(args[index.getAndIncrement()]);
            return new Args(javaHome, cacheFile, compileOrder, compilerBridgeJar, scalaVersion, compilerAndDependencies, libraryAndDependencies, classpathElements, sources, classesDirectory, scalacOptions, javacOptions, debugEnabled);
        }
    }
}

