/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.AncestorOrSelfDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.AndDependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.BasicArtifact;
import scala_maven.FileUtils;
import scala_maven.VersionNumber;
import scala_maven.VersionNumberMask;
import scala_maven_dependency.CheckScalaVersionVisitor;
import scala_maven_dependency.ScalaDistroArtifactFilter;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.JavaMainCallerByFork;
import scala_maven_executions.JavaMainCallerInProcess;
import scala_maven_executions.JavaMainCallerSupport;
import scala_maven_executions.MainHelper;

public abstract class ScalaMojoSupport
extends AbstractMojo {
    private static final String SCALA_LIBRARY_ARTIFACTID = "scala-library";
    private static final String SCALA_REFLECT_ARTIFACTID = "scala-reflect";
    private static final String SCALA_COMPILER_ARTIFACTID = "scala-compiler";
    protected static final String POM = "pom";
    static final String JAR = "jar";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Component
    RepositorySystem factory;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    private ArtifactRepository localRepo;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepos;
    @Parameter
    protected BasicArtifact[] dependencies;
    @Parameter
    private BasicArtifact[] compilerPlugins;
    @Parameter
    protected String[] jvmArgs;
    @Parameter
    protected String[] args;
    @Parameter(property="addScalacArgs")
    private String addScalacArgs;
    @Parameter(required=true, property="maven.scala.className", defaultValue="scala.tools.nsc.Main")
    protected String scalaClassName;
    @Parameter(property="scala.version")
    private String scalaVersion;
    @Parameter(property="scala.organization", defaultValue="org.scala-lang")
    private String scalaOrganization;
    @Parameter(property="scala.compat.version")
    private String scalaCompatVersion;
    @Parameter(property="scala.home")
    private String scalaHome;
    @Parameter(property="javacArgs")
    protected String[] javacArgs;
    @Parameter(property="javacGenerateDebugSymbols", defaultValue="true")
    protected boolean javacGenerateDebugSymbols = true;
    @Parameter(property="addJavacArgs")
    protected String addJavacArgs;
    @Parameter(property="maven.compiler.source")
    protected String source;
    @Parameter(property="maven.compiler.target")
    protected String target;
    @Parameter(property="project.build.sourceEncoding", defaultValue="UTF-8")
    protected String encoding;
    @Parameter(property="displayCmd", defaultValue="false", required=true)
    public boolean displayCmd;
    @Parameter(defaultValue="true")
    protected boolean fork = true;
    @Parameter(defaultValue="false")
    protected boolean forceUseArgFile = false;
    @Parameter(property="maven.scala.checkConsistency", defaultValue="true")
    protected boolean checkMultipleScalaVersions;
    @Parameter(defaultValue="false")
    protected boolean failOnMultipleScalaVersions = false;
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    protected boolean useCanonicalPath = true;
    @Component
    protected MavenProjectBuilder mavenProjectBuilder;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private DependencyGraphBuilder dependencyTreeBuilder;
    @Component
    protected ToolchainManager toolchainManager;
    @Parameter(defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    private VersionNumber _scalaVersionN;

    public String getScalaOrganization() {
        return this.scalaOrganization;
    }

    final Artifact scalaCompilerArtifact(String scalaVersion) {
        return this.factory.createArtifact(this.getScalaOrganization(), SCALA_COMPILER_ARTIFACTID, scalaVersion, "", POM);
    }

    final Set<Artifact> resolveArtifactDependencies(Artifact artifact) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("test"));
        filter.add(art -> !art.isOptional());
        return this.resolveDependencyArtifacts(artifact, (ArtifactFilter)filter, (ArtifactFilter)filter);
    }

    private Set<Artifact> resolveDependencyArtifacts(Artifact artifact, ArtifactFilter collectionFilter, ArtifactFilter resolutionFilter) {
        return this.resolveDependencyArtifacts(artifact, collectionFilter, resolutionFilter, this.remoteRepos, this.localRepo);
    }

    private Set<Artifact> resolveDependencyArtifacts(Artifact artifact, ArtifactFilter collectionFilter, ArtifactFilter resolutionFilter, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) {
        ArtifactResolutionRequest arr = this.createArtifactResolutionRequest(artifact, collectionFilter, resolutionFilter, remoteRepositories, localRepository);
        return this.resolver.resolve(arr).getArtifacts();
    }

    private ArtifactResolutionRequest createArtifactResolutionRequest(Artifact artifact, ArtifactFilter collectionFilter, ArtifactFilter resolutionFilter, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) {
        ArtifactResolutionRequest arr = new ArtifactResolutionRequest();
        arr.setArtifact(artifact);
        arr.setCollectionFilter(collectionFilter);
        arr.setResolutionFilter(resolutionFilter);
        arr.setResolveRoot(false);
        arr.setResolveTransitively(true);
        arr.setRemoteRepositories(remoteRepositories);
        arr.setLocalRepository(localRepository);
        return arr;
    }

    private void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath) throws Exception {
        this.addToClasspath(groupId, artifactId, version, classpath, true);
    }

    private void addToClasspath(String groupId, String artifactId, String version, Set<String> classpath, boolean addDependencies) throws Exception {
        this.addToClasspath(this.factory.createArtifact(groupId, artifactId, version, "runtime", JAR), classpath, addDependencies);
    }

    private void addToClasspath(String groupId, String artifactId, String version, String classifier, Set<String> classpath, boolean addDependencies) throws Exception {
        Dependency d = new Dependency();
        d.setGroupId(groupId);
        d.setArtifactId(artifactId);
        d.setVersion(version);
        d.setType(JAR);
        d.setClassifier(classifier);
        d.setScope("runtime");
        this.addToClasspath(this.factory.createDependencyArtifact(d), classpath, addDependencies);
    }

    void addToClasspath(Artifact artifact, Set<String> classpath, boolean addDependencies) throws Exception {
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        classpath.add(FileUtils.pathOf(artifact.getFile(), this.useCanonicalPath));
        if (addDependencies) {
            for (Artifact dep : this.resolveArtifactDependencies(artifact)) {
                this.addToClasspath(dep, classpath, addDependencies);
            }
        }
    }

    void addCompilerToClasspath(Set<String> classpath) throws Exception {
        classpath.add(FileUtils.pathOf(this.getCompilerJar(), this.useCanonicalPath));
        for (File dep : this.getCompilerDependencies()) {
            classpath.add(FileUtils.pathOf(dep, this.useCanonicalPath));
        }
    }

    void addLibraryToClasspath(Set<String> classpath) throws Exception {
        classpath.add(FileUtils.pathOf(this.getLibraryJar(), this.useCanonicalPath));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String oldWay = System.getProperty("maven.scala.version");
            if (oldWay != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.version' is deprecated, use 'scala.version' instead");
                if (this.scalaVersion != null) {
                    this.scalaVersion = oldWay;
                }
            }
            if ((oldWay = System.getProperty("maven.scala.displayCmd")) != null) {
                this.getLog().warn((CharSequence)"using 'maven.scala.displayCmd' is deprecated, use 'displayCmd' instead");
                this.displayCmd = this.displayCmd || Boolean.parseBoolean(oldWay);
            }
            this.checkScalaVersion();
            this.doExecute();
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (RuntimeException | MojoFailureException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc, exc);
        }
    }

    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    VersionNumber findScalaVersion() throws Exception {
        if (this._scalaVersionN == null) {
            String detectedScalaVersion = this.scalaVersion;
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                detectedScalaVersion = this.findScalaVersionFromDependencies();
            }
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                if (!POM.equals(this.project.getPackaging().toLowerCase())) {
                    String error = this.getScalaOrganization() + ":" + SCALA_LIBRARY_ARTIFACTID + " is missing from project dependencies";
                    this.getLog().error((CharSequence)error);
                    throw new UnsupportedOperationException(error);
                }
            } else {
                boolean isSnapshot = ArtifactUtils.isSnapshot((String)detectedScalaVersion);
                if (isSnapshot && !detectedScalaVersion.endsWith("-SNAPSHOT")) {
                    detectedScalaVersion = detectedScalaVersion.substring(0, detectedScalaVersion.lastIndexOf(45, detectedScalaVersion.lastIndexOf(45) - 1)) + "-SNAPSHOT";
                }
            }
            if (StringUtils.isEmpty((String)detectedScalaVersion)) {
                throw new MojoFailureException("no scalaVersion detected or set");
            }
            if (StringUtils.isNotEmpty((String)this.scalaVersion) && !this.scalaVersion.equals(detectedScalaVersion)) {
                this.getLog().warn((CharSequence)"scala library version define in dependencies doesn't match the scalaVersion of the plugin");
            }
            this._scalaVersionN = new VersionNumber(detectedScalaVersion);
        }
        return this._scalaVersionN;
    }

    private String findScalaVersionFromDependencies() {
        return this.findVersionFromDependencies(this.getScalaOrganization(), SCALA_LIBRARY_ARTIFACTID);
    }

    private String findVersionFromDependencies(String groupId, String artifactId) {
        String version = null;
        for (Dependency dep : this.getDependencies()) {
            if (!groupId.equals(dep.getGroupId()) || !artifactId.equals(dep.getArtifactId())) continue;
            version = dep.getVersion();
        }
        if (StringUtils.isEmpty(version)) {
            ArrayList deps = new ArrayList();
            deps.addAll(this.project.getModel().getDependencies());
            if (this.project.getModel().getDependencyManagement() != null) {
                deps.addAll(this.project.getModel().getDependencyManagement().getDependencies());
            }
            for (Dependency dep : deps) {
                if (!groupId.equals(dep.getGroupId()) || !artifactId.equals(dep.getArtifactId())) continue;
                version = dep.getVersion();
            }
        }
        return version;
    }

    void checkScalaVersion() throws Exception {
        String sv = this.findScalaVersion().toString();
        if (StringUtils.isNotEmpty((String)this.scalaHome)) {
            this.getLog().warn((CharSequence)String.format("local scala-library.jar and scala-compiler.jar from scalaHome(%s) used instead of scala %s", this.scalaHome, sv));
        }
        if (this.checkMultipleScalaVersions) {
            this.checkCorrectVersionsOfScalaLibrary(sv);
        }
    }

    private void checkCorrectVersionsOfScalaLibrary(String scalaDefVersion) throws Exception {
        VersionNumber requiredScalaVersion;
        this.getLog().debug((CharSequence)"Checking for multiple versions of scala");
        VersionNumber sv = new VersionNumber(scalaDefVersion);
        VersionNumber versionNumber = requiredScalaVersion = StringUtils.isNotEmpty((String)this.scalaCompatVersion) ? new VersionNumberMask(this.scalaCompatVersion) : sv;
        if (requiredScalaVersion.compareTo(sv) != 0) {
            String msg = String.format("Scala library detected %s doesn't match scala.compat.version : %s", sv, requiredScalaVersion);
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)msg);
                throw new MojoFailureException(msg);
            }
            this.getLog().warn((CharSequence)msg);
        }
        ProjectBuildingRequest request = this.project.getProjectBuildingRequest();
        request.setProject(this.project);
        this.checkArtifactForScalaVersion(requiredScalaVersion, this.dependencyTreeBuilder.buildDependencyGraph(request, null));
    }

    private void checkArtifactForScalaVersion(VersionNumber requiredScalaVersion, DependencyNode rootNode) throws Exception {
        CheckScalaVersionVisitor visitor = new CheckScalaVersionVisitor(requiredScalaVersion, this.getLog(), this.getScalaOrganization());
        CollectingDependencyNodeVisitor collectingVisitor = new CollectingDependencyNodeVisitor();
        FilteringDependencyNodeVisitor firstPassVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collectingVisitor, this.createScalaDistroDependencyFilter());
        rootNode.accept((DependencyNodeVisitor)firstPassVisitor);
        AncestorOrSelfDependencyNodeFilter secondPassFilter = new AncestorOrSelfDependencyNodeFilter(collectingVisitor.getNodes());
        FilteringDependencyNodeVisitor filteredVisitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)visitor, (DependencyNodeFilter)secondPassFilter);
        rootNode.accept((DependencyNodeVisitor)filteredVisitor);
        if (visitor.isFailed()) {
            visitor.logScalaDependents();
            if (this.failOnMultipleScalaVersions) {
                this.getLog().error((CharSequence)"Multiple versions of scala libraries detected!");
                throw new MojoFailureException("Multiple versions of scala libraries detected!");
            }
            this.getLog().warn((CharSequence)"Multiple versions of scala libraries detected!");
        }
    }

    private DependencyNodeFilter createScalaDistroDependencyFilter() {
        ArrayList<ScalaDistroArtifactFilter> filters = new ArrayList<ScalaDistroArtifactFilter>();
        filters.add(new ScalaDistroArtifactFilter(this.getScalaOrganization()));
        return new AndDependencyNodeFilter(filters);
    }

    protected abstract void doExecute() throws Exception;

    protected JavaMainCaller getScalaCommand() throws Exception {
        return this.getScalaCommand(this.fork, this.scalaClassName);
    }

    final JavaMainCaller getScalaCommand(boolean forkOverride, String mainClass) throws Exception {
        JavaMainCaller cmd = this.getEmptyScalaCommand(mainClass, forkOverride);
        cmd.addArgs(this.args);
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            cmd.addArgs(StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        this.addCompilerPluginOptions(cmd);
        cmd.addJvmArgs(this.jvmArgs);
        return cmd;
    }

    final JavaMainCaller getEmptyScalaCommand(String mainClass) throws Exception {
        return this.getEmptyScalaCommand(mainClass, this.fork);
    }

    private JavaMainCaller getEmptyScalaCommand(String mainClass, boolean forkOverride) throws Exception {
        JavaMainCallerSupport cmd;
        if (forkOverride != this.fork) {
            super.getLog().info((CharSequence)"Fork behavior overridden");
            super.getLog().info((CharSequence)String.format("Fork for this execution is %s.", String.valueOf(forkOverride)));
        }
        String toolcp = this.getToolClasspath();
        if (forkOverride) {
            boolean bootcp = true;
            if (this.args != null) {
                for (String arg : this.args) {
                    bootcp = bootcp && !"-nobootcp".equals(arg);
                }
            }
            String cp = bootcp ? "" : toolcp;
            bootcp = bootcp && (!StringUtils.isNotEmpty((String)this.addScalacArgs) || !this.addScalacArgs.contains("-nobootcp"));
            this.getLog().debug((CharSequence)("use java command with args in file forced : " + this.forceUseArgFile));
            cmd = new JavaMainCallerByFork(this, mainClass, cp, null, null, this.forceUseArgFile, this.toolchainManager.getToolchainFromBuildContext("jdk", this.session));
            if (bootcp) {
                cmd.addJvmArgs("-Xbootclasspath/a:" + toolcp);
            }
        } else {
            cmd = new JavaMainCallerInProcess(this, mainClass, toolcp, null, null);
        }
        return cmd;
    }

    private String getToolClasspath() throws Exception {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        this.addLibraryToClasspath(classpath);
        this.addCompilerToClasspath(classpath);
        if (this.dependencies != null) {
            for (BasicArtifact artifact : this.dependencies) {
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, classpath);
            }
        }
        return MainHelper.toMultiPath(classpath.toArray(new String[0]));
    }

    protected List<String> getScalaOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        if (this.args != null) {
            Collections.addAll(options, this.args);
        }
        if (StringUtils.isNotEmpty((String)this.addScalacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addScalacArgs, (String)"|"));
        }
        options.addAll(this.getCompilerPluginOptions());
        return options;
    }

    protected List<String> getJavacOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.javacArgs != null) {
            Collections.addAll(options, this.javacArgs);
        }
        if (StringUtils.isNotEmpty((String)this.addJavacArgs)) {
            Collections.addAll(options, StringUtils.split((String)this.addJavacArgs, (String)"|"));
        }
        if (this.javacGenerateDebugSymbols) {
            options.add("-g");
        }
        if (this.target != null && !this.target.isEmpty()) {
            options.add("-target");
            options.add(this.target);
        }
        if (this.source != null && !this.source.isEmpty()) {
            options.add("-source");
            options.add(this.source);
        }
        if (this.encoding != null) {
            options.add("-encoding");
            options.add(this.encoding);
        }
        return options;
    }

    protected File getLibraryJar() throws Exception {
        if (StringUtils.isNotEmpty((String)this.scalaHome)) {
            File lib = new File(this.scalaHome, "lib");
            return new File(lib, "scala-library.jar");
        }
        return this.getArtifactJar(this.getScalaOrganization(), SCALA_LIBRARY_ARTIFACTID, this.findScalaVersion().toString());
    }

    protected File getReflectJar() throws Exception {
        if (StringUtils.isNotEmpty((String)this.scalaHome)) {
            File lib = new File(this.scalaHome, "lib");
            return new File(lib, "scala-reflect.jar");
        }
        return this.getArtifactJar(this.getScalaOrganization(), SCALA_REFLECT_ARTIFACTID, this.findScalaVersion().toString());
    }

    protected File getCompilerJar() throws Exception {
        if (StringUtils.isNotEmpty((String)this.scalaHome)) {
            File lib = new File(this.scalaHome, "lib");
            return new File(lib, "scala-compiler.jar");
        }
        return this.getArtifactJar(this.getScalaOrganization(), SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString());
    }

    protected List<File> getCompilerDependencies() throws Exception {
        ArrayList<File> d = new ArrayList<File>();
        if (StringUtils.isEmpty((String)this.scalaHome)) {
            for (Artifact artifact : this.getAllDependencies(this.getScalaOrganization(), SCALA_COMPILER_ARTIFACTID, this.findScalaVersion().toString())) {
                d.add(artifact.getFile());
            }
        } else {
            for (File f : new File(this.scalaHome, "lib").listFiles()) {
                String name = f.getName();
                if (!name.endsWith(".jar") || name.contains(SCALA_LIBRARY_ARTIFACTID) || name.contains(SCALA_COMPILER_ARTIFACTID)) continue;
                d.add(f);
            }
        }
        return d;
    }

    protected File getArtifactJar(String groupId, String artifactId, String version) throws Exception {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "runtime", JAR);
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact.getFile();
    }

    private Set<Artifact> getAllDependencies(String groupId, String artifactId, String version) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Artifact pom = this.factory.createArtifact(groupId, artifactId, version, "", POM);
        Set<Artifact> d = this.resolveArtifactDependencies(pom);
        result.addAll(d);
        for (Artifact dependency : d) {
            Set<Artifact> transitive = this.getAllDependencies(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
            result.addAll(transitive);
        }
        return result;
    }

    protected boolean isJavaSupportedByCompiler() throws Exception {
        return this.findScalaVersion().compareTo(new VersionNumber("2.7.2")) >= 0;
    }

    protected void addCompilerPluginOptions(JavaMainCaller scalac) throws Exception {
        for (String option : this.getCompilerPluginOptions()) {
            scalac.addArgs(option);
        }
    }

    private List<String> getCompilerPluginOptions() throws Exception {
        ArrayList<String> options = new ArrayList<String>();
        for (String plugin : this.getCompilerPlugins()) {
            options.add("-Xplugin:" + plugin);
        }
        return options;
    }

    private Set<String> getCompilerPlugins() throws Exception {
        HashSet<String> plugins = new HashSet<String>();
        if (this.compilerPlugins != null) {
            LinkedHashSet<String> ignoreClasspath = new LinkedHashSet<String>();
            this.addCompilerToClasspath(ignoreClasspath);
            this.addLibraryToClasspath(ignoreClasspath);
            for (BasicArtifact artifact : this.compilerPlugins) {
                this.getLog().info((CharSequence)("compiler plugin: " + artifact.toString()));
                HashSet<String> pluginClassPath = new HashSet<String>();
                this.addToClasspath(artifact.groupId, artifact.artifactId, artifact.version, artifact.classifier, pluginClassPath, false);
                pluginClassPath.removeAll(ignoreClasspath);
                plugins.addAll(pluginClassPath);
            }
        }
        return plugins;
    }

    protected String findVersionFromPluginArtifacts(String groupId, String artifactId) {
        for (Artifact art : this.pluginArtifacts) {
            if (!groupId.equals(art.getGroupId()) || !artifactId.equals(art.getArtifactId())) continue;
            return art.getVersion();
        }
        throw new IllegalArgumentException("Could not locate artifact " + groupId + ":" + artifactId + " in plugin's dependencies");
    }
}

